package zio.aws.directconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  VLAN,
  VirtualInterfaceName,
  BGPAuthKey,
  ASN,
  AmazonAddress,
  CustomerAddress
}
import scala.jdk.CollectionConverters._
final case class NewPublicVirtualInterfaceAllocation(
    virtualInterfaceName: VirtualInterfaceName,
    vlan: VLAN,
    asn: ASN,
    authKey: Option[BGPAuthKey] = None,
    amazonAddress: Option[AmazonAddress] = None,
    customerAddress: Option[CustomerAddress] = None,
    addressFamily: Option[zio.aws.directconnect.model.AddressFamily] = None,
    routeFilterPrefixes: Option[
      Iterable[zio.aws.directconnect.model.RouteFilterPrefix]
    ] = None,
    tags: Option[Iterable[zio.aws.directconnect.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterfaceAllocation = {
    import NewPublicVirtualInterfaceAllocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterfaceAllocation
      .builder()
      .virtualInterfaceName(
        VirtualInterfaceName.unwrap(virtualInterfaceName): java.lang.String
      )
      .vlan(VLAN.unwrap(vlan): Integer)
      .asn(ASN.unwrap(asn): Integer)
      .optionallyWith(
        authKey.map(value => BGPAuthKey.unwrap(value): java.lang.String)
      )(_.authKey)
      .optionallyWith(
        amazonAddress.map(value =>
          AmazonAddress.unwrap(value): java.lang.String
        )
      )(_.amazonAddress)
      .optionallyWith(
        customerAddress.map(value =>
          CustomerAddress.unwrap(value): java.lang.String
        )
      )(_.customerAddress)
      .optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily)
      .optionallyWith(
        routeFilterPrefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routeFilterPrefixes)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.NewPublicVirtualInterfaceAllocation.ReadOnly =
    zio.aws.directconnect.model.NewPublicVirtualInterfaceAllocation
      .wrap(buildAwsValue())
}
object NewPublicVirtualInterfaceAllocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterfaceAllocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.NewPublicVirtualInterfaceAllocation =
      zio.aws.directconnect.model.NewPublicVirtualInterfaceAllocation(
        virtualInterfaceName,
        vlan,
        asn,
        authKey.map(value => value),
        amazonAddress.map(value => value),
        customerAddress.map(value => value),
        addressFamily.map(value => value),
        routeFilterPrefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def virtualInterfaceName: VirtualInterfaceName
    def vlan: VLAN
    def asn: ASN
    def authKey: Option[BGPAuthKey]
    def amazonAddress: Option[AmazonAddress]
    def customerAddress: Option[CustomerAddress]
    def addressFamily: Option[zio.aws.directconnect.model.AddressFamily]
    def routeFilterPrefixes
        : Option[List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]]
    def tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def getVirtualInterfaceName: ZIO[Any, Nothing, VirtualInterfaceName] =
      ZIO.succeed(virtualInterfaceName)
    def getVlan: ZIO[Any, Nothing, VLAN] = ZIO.succeed(vlan)
    def getAsn: ZIO[Any, Nothing, ASN] = ZIO.succeed(asn)
    def getAuthKey: ZIO[Any, AwsError, BGPAuthKey] =
      AwsError.unwrapOptionField("authKey", authKey)
    def getAmazonAddress: ZIO[Any, AwsError, AmazonAddress] =
      AwsError.unwrapOptionField("amazonAddress", amazonAddress)
    def getCustomerAddress: ZIO[Any, AwsError, CustomerAddress] =
      AwsError.unwrapOptionField("customerAddress", customerAddress)
    def getAddressFamily
        : ZIO[Any, AwsError, zio.aws.directconnect.model.AddressFamily] =
      AwsError.unwrapOptionField("addressFamily", addressFamily)
    def getRouteFilterPrefixes: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly
    ]] = AwsError.unwrapOptionField("routeFilterPrefixes", routeFilterPrefixes)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterfaceAllocation
  ) extends zio.aws.directconnect.model.NewPublicVirtualInterfaceAllocation.ReadOnly {
    override val virtualInterfaceName: VirtualInterfaceName =
      zio.aws.directconnect.model.primitives
        .VirtualInterfaceName(impl.virtualInterfaceName())
    override val vlan: VLAN =
      zio.aws.directconnect.model.primitives.VLAN(impl.vlan())
    override val asn: ASN =
      zio.aws.directconnect.model.primitives.ASN(impl.asn())
    override val authKey: Option[BGPAuthKey] = scala
      .Option(impl.authKey())
      .map(value => zio.aws.directconnect.model.primitives.BGPAuthKey(value))
    override val amazonAddress: Option[AmazonAddress] = scala
      .Option(impl.amazonAddress())
      .map(value => zio.aws.directconnect.model.primitives.AmazonAddress(value))
    override val customerAddress: Option[CustomerAddress] = scala
      .Option(impl.customerAddress())
      .map(value =>
        zio.aws.directconnect.model.primitives.CustomerAddress(value)
      )
    override val addressFamily
        : Option[zio.aws.directconnect.model.AddressFamily] = scala
      .Option(impl.addressFamily())
      .map(value => zio.aws.directconnect.model.AddressFamily.wrap(value))
    override val routeFilterPrefixes
        : Option[List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]] =
      scala
        .Option(impl.routeFilterPrefixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.RouteFilterPrefix.wrap(item)
          }.toList
        )
    override val tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterfaceAllocation
  ): zio.aws.directconnect.model.NewPublicVirtualInterfaceAllocation.ReadOnly =
    new Wrapper(impl)
}
