package zio.aws.directconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  DirectConnectGatewayId,
  VLAN,
  VirtualInterfaceName,
  MTU,
  BGPAuthKey,
  EnableSiteLink,
  VirtualGatewayId,
  ASN,
  AmazonAddress,
  CustomerAddress
}
import scala.jdk.CollectionConverters._
final case class NewPrivateVirtualInterface(
    virtualInterfaceName: VirtualInterfaceName,
    vlan: VLAN,
    asn: ASN,
    mtu: Option[MTU] = None,
    authKey: Option[BGPAuthKey] = None,
    amazonAddress: Option[AmazonAddress] = None,
    customerAddress: Option[CustomerAddress] = None,
    addressFamily: Option[zio.aws.directconnect.model.AddressFamily] = None,
    virtualGatewayId: Option[VirtualGatewayId] = None,
    directConnectGatewayId: Option[DirectConnectGatewayId] = None,
    tags: Option[Iterable[zio.aws.directconnect.model.Tag]] = None,
    enableSiteLink: Option[EnableSiteLink] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterface = {
    import NewPrivateVirtualInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterface
      .builder()
      .virtualInterfaceName(
        VirtualInterfaceName.unwrap(virtualInterfaceName): java.lang.String
      )
      .vlan(VLAN.unwrap(vlan): Integer)
      .asn(ASN.unwrap(asn): Integer)
      .optionallyWith(mtu.map(value => MTU.unwrap(value): Integer))(_.mtu)
      .optionallyWith(
        authKey.map(value => BGPAuthKey.unwrap(value): java.lang.String)
      )(_.authKey)
      .optionallyWith(
        amazonAddress.map(value =>
          AmazonAddress.unwrap(value): java.lang.String
        )
      )(_.amazonAddress)
      .optionallyWith(
        customerAddress.map(value =>
          CustomerAddress.unwrap(value): java.lang.String
        )
      )(_.customerAddress)
      .optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily)
      .optionallyWith(
        virtualGatewayId.map(value =>
          VirtualGatewayId.unwrap(value): java.lang.String
        )
      )(_.virtualGatewayId)
      .optionallyWith(
        directConnectGatewayId.map(value =>
          DirectConnectGatewayId.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        enableSiteLink.map(value =>
          EnableSiteLink.unwrap(value): java.lang.Boolean
        )
      )(_.enableSiteLink)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.NewPrivateVirtualInterface.ReadOnly =
    zio.aws.directconnect.model.NewPrivateVirtualInterface.wrap(buildAwsValue())
}
object NewPrivateVirtualInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.NewPrivateVirtualInterface =
      zio.aws.directconnect.model.NewPrivateVirtualInterface(
        virtualInterfaceName,
        vlan,
        asn,
        mtu.map(value => value),
        authKey.map(value => value),
        amazonAddress.map(value => value),
        customerAddress.map(value => value),
        addressFamily.map(value => value),
        virtualGatewayId.map(value => value),
        directConnectGatewayId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableSiteLink.map(value => value)
      )
    def virtualInterfaceName: VirtualInterfaceName
    def vlan: VLAN
    def asn: ASN
    def mtu: Option[MTU]
    def authKey: Option[BGPAuthKey]
    def amazonAddress: Option[AmazonAddress]
    def customerAddress: Option[CustomerAddress]
    def addressFamily: Option[zio.aws.directconnect.model.AddressFamily]
    def virtualGatewayId: Option[VirtualGatewayId]
    def directConnectGatewayId: Option[DirectConnectGatewayId]
    def tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def enableSiteLink: Option[EnableSiteLink]
    def getVirtualInterfaceName: ZIO[Any, Nothing, VirtualInterfaceName] =
      ZIO.succeed(virtualInterfaceName)
    def getVlan: ZIO[Any, Nothing, VLAN] = ZIO.succeed(vlan)
    def getAsn: ZIO[Any, Nothing, ASN] = ZIO.succeed(asn)
    def getMtu: ZIO[Any, AwsError, MTU] = AwsError.unwrapOptionField("mtu", mtu)
    def getAuthKey: ZIO[Any, AwsError, BGPAuthKey] =
      AwsError.unwrapOptionField("authKey", authKey)
    def getAmazonAddress: ZIO[Any, AwsError, AmazonAddress] =
      AwsError.unwrapOptionField("amazonAddress", amazonAddress)
    def getCustomerAddress: ZIO[Any, AwsError, CustomerAddress] =
      AwsError.unwrapOptionField("customerAddress", customerAddress)
    def getAddressFamily
        : ZIO[Any, AwsError, zio.aws.directconnect.model.AddressFamily] =
      AwsError.unwrapOptionField("addressFamily", addressFamily)
    def getVirtualGatewayId: ZIO[Any, AwsError, VirtualGatewayId] =
      AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayId)
    def getDirectConnectGatewayId: ZIO[Any, AwsError, DirectConnectGatewayId] =
      AwsError.unwrapOptionField(
        "directConnectGatewayId",
        directConnectGatewayId
      )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEnableSiteLink: ZIO[Any, AwsError, EnableSiteLink] =
      AwsError.unwrapOptionField("enableSiteLink", enableSiteLink)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterface
  ) extends zio.aws.directconnect.model.NewPrivateVirtualInterface.ReadOnly {
    override val virtualInterfaceName: VirtualInterfaceName =
      zio.aws.directconnect.model.primitives
        .VirtualInterfaceName(impl.virtualInterfaceName())
    override val vlan: VLAN =
      zio.aws.directconnect.model.primitives.VLAN(impl.vlan())
    override val asn: ASN =
      zio.aws.directconnect.model.primitives.ASN(impl.asn())
    override val mtu: Option[MTU] = scala
      .Option(impl.mtu())
      .map(value => zio.aws.directconnect.model.primitives.MTU(value))
    override val authKey: Option[BGPAuthKey] = scala
      .Option(impl.authKey())
      .map(value => zio.aws.directconnect.model.primitives.BGPAuthKey(value))
    override val amazonAddress: Option[AmazonAddress] = scala
      .Option(impl.amazonAddress())
      .map(value => zio.aws.directconnect.model.primitives.AmazonAddress(value))
    override val customerAddress: Option[CustomerAddress] = scala
      .Option(impl.customerAddress())
      .map(value =>
        zio.aws.directconnect.model.primitives.CustomerAddress(value)
      )
    override val addressFamily
        : Option[zio.aws.directconnect.model.AddressFamily] = scala
      .Option(impl.addressFamily())
      .map(value => zio.aws.directconnect.model.AddressFamily.wrap(value))
    override val virtualGatewayId: Option[VirtualGatewayId] = scala
      .Option(impl.virtualGatewayId())
      .map(value =>
        zio.aws.directconnect.model.primitives.VirtualGatewayId(value)
      )
    override val directConnectGatewayId: Option[DirectConnectGatewayId] = scala
      .Option(impl.directConnectGatewayId())
      .map(value =>
        zio.aws.directconnect.model.primitives.DirectConnectGatewayId(value)
      )
    override val tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
    override val enableSiteLink: Option[EnableSiteLink] = scala
      .Option(impl.enableSiteLink())
      .map(value =>
        zio.aws.directconnect.model.primitives.EnableSiteLink(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterface
  ): zio.aws.directconnect.model.NewPrivateVirtualInterface.ReadOnly =
    new Wrapper(impl)
}
