package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  ProviderName,
  LocationName,
  PortSpeed,
  Region,
  LocationCode
}
import scala.jdk.CollectionConverters._
final case class Location(
    locationCode: Option[LocationCode] = None,
    locationName: Option[LocationName] = None,
    region: Option[Region] = None,
    availablePortSpeeds: Option[Iterable[PortSpeed]] = None,
    availableProviders: Option[Iterable[ProviderName]] = None,
    availableMacSecPortSpeeds: Option[Iterable[PortSpeed]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.Location = {
    import Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.Location
      .builder()
      .optionallyWith(
        locationCode.map(value => LocationCode.unwrap(value): java.lang.String)
      )(_.locationCode)
      .optionallyWith(
        locationName.map(value => LocationName.unwrap(value): java.lang.String)
      )(_.locationName)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        availablePortSpeeds.map(value =>
          value.map { item =>
            PortSpeed.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availablePortSpeeds)
      .optionallyWith(
        availableProviders.map(value =>
          value.map { item =>
            ProviderName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availableProviders)
      .optionallyWith(
        availableMacSecPortSpeeds.map(value =>
          value.map { item =>
            PortSpeed.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availableMacSecPortSpeeds)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.Location.ReadOnly =
    zio.aws.directconnect.model.Location.wrap(buildAwsValue())
}
object Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.Location =
      zio.aws.directconnect.model.Location(
        locationCode.map(value => value),
        locationName.map(value => value),
        region.map(value => value),
        availablePortSpeeds.map(value => value),
        availableProviders.map(value => value),
        availableMacSecPortSpeeds.map(value => value)
      )
    def locationCode: Option[LocationCode]
    def locationName: Option[LocationName]
    def region: Option[Region]
    def availablePortSpeeds: Option[List[PortSpeed]]
    def availableProviders: Option[List[ProviderName]]
    def availableMacSecPortSpeeds: Option[List[PortSpeed]]
    def getLocationCode: ZIO[Any, AwsError, LocationCode] =
      AwsError.unwrapOptionField("locationCode", locationCode)
    def getLocationName: ZIO[Any, AwsError, LocationName] =
      AwsError.unwrapOptionField("locationName", locationName)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getAvailablePortSpeeds: ZIO[Any, AwsError, List[PortSpeed]] =
      AwsError.unwrapOptionField("availablePortSpeeds", availablePortSpeeds)
    def getAvailableProviders: ZIO[Any, AwsError, List[ProviderName]] =
      AwsError.unwrapOptionField("availableProviders", availableProviders)
    def getAvailableMacSecPortSpeeds: ZIO[Any, AwsError, List[PortSpeed]] =
      AwsError.unwrapOptionField(
        "availableMacSecPortSpeeds",
        availableMacSecPortSpeeds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.Location
  ) extends zio.aws.directconnect.model.Location.ReadOnly {
    override val locationCode: Option[LocationCode] = scala
      .Option(impl.locationCode())
      .map(value => zio.aws.directconnect.model.primitives.LocationCode(value))
    override val locationName: Option[LocationName] = scala
      .Option(impl.locationName())
      .map(value => zio.aws.directconnect.model.primitives.LocationName(value))
    override val region: Option[Region] = scala
      .Option(impl.region())
      .map(value => zio.aws.directconnect.model.primitives.Region(value))
    override val availablePortSpeeds: Option[List[PortSpeed]] = scala
      .Option(impl.availablePortSpeeds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.primitives.PortSpeed(item)
        }.toList
      )
    override val availableProviders: Option[List[ProviderName]] = scala
      .Option(impl.availableProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.primitives.ProviderName(item)
        }.toList
      )
    override val availableMacSecPortSpeeds: Option[List[PortSpeed]] = scala
      .Option(impl.availableMacSecPortSpeeds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.primitives.PortSpeed(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.Location
  ): zio.aws.directconnect.model.Location.ReadOnly = new Wrapper(impl)
}
