package zio.aws.directconnect.model
import scala.jdk.CollectionConverters._
sealed trait DirectConnectGatewayAttachmentState {
  def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState
}
object DirectConnectGatewayAttachmentState {
  def wrap(
      value: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState
  ): zio.aws.directconnect.model.DirectConnectGatewayAttachmentState =
    value match {
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.ATTACHING =>
        val r = attaching
        r
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.ATTACHED =>
        val r = attached
        r
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.DETACHING =>
        val r = detaching
        r
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.DETACHED =>
        val r = detached
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.directconnect.model.DirectConnectGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.UNKNOWN_TO_SDK_VERSION
  }
  case object attaching
      extends zio.aws.directconnect.model.DirectConnectGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.ATTACHING
  }
  case object attached
      extends zio.aws.directconnect.model.DirectConnectGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.ATTACHED
  }
  case object detaching
      extends zio.aws.directconnect.model.DirectConnectGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.DETACHING
  }
  case object detached
      extends zio.aws.directconnect.model.DirectConnectGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.DETACHED
  }
}
