package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  DirectConnectGatewayId,
  OwnerAccount,
  VirtualInterfaceRegion,
  StateChangeError,
  VirtualInterfaceId
}
import scala.jdk.CollectionConverters._
final case class DirectConnectGatewayAttachment(
    directConnectGatewayId: Option[DirectConnectGatewayId] = None,
    virtualInterfaceId: Option[VirtualInterfaceId] = None,
    virtualInterfaceRegion: Option[VirtualInterfaceRegion] = None,
    virtualInterfaceOwnerAccount: Option[OwnerAccount] = None,
    attachmentState: Option[
      zio.aws.directconnect.model.DirectConnectGatewayAttachmentState
    ] = None,
    attachmentType: Option[
      zio.aws.directconnect.model.DirectConnectGatewayAttachmentType
    ] = None,
    stateChangeError: Option[StateChangeError] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment = {
    import DirectConnectGatewayAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment
      .builder()
      .optionallyWith(
        directConnectGatewayId.map(value =>
          DirectConnectGatewayId.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayId)
      .optionallyWith(
        virtualInterfaceId.map(value =>
          VirtualInterfaceId.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceId)
      .optionallyWith(
        virtualInterfaceRegion.map(value =>
          VirtualInterfaceRegion.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceRegion)
      .optionallyWith(
        virtualInterfaceOwnerAccount.map(value =>
          OwnerAccount.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceOwnerAccount)
      .optionallyWith(attachmentState.map(value => value.unwrap))(
        _.attachmentState
      )
      .optionallyWith(attachmentType.map(value => value.unwrap))(
        _.attachmentType
      )
      .optionallyWith(
        stateChangeError.map(value =>
          StateChangeError.unwrap(value): java.lang.String
        )
      )(_.stateChangeError)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DirectConnectGatewayAttachment.ReadOnly =
    zio.aws.directconnect.model.DirectConnectGatewayAttachment
      .wrap(buildAwsValue())
}
object DirectConnectGatewayAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DirectConnectGatewayAttachment =
      zio.aws.directconnect.model.DirectConnectGatewayAttachment(
        directConnectGatewayId.map(value => value),
        virtualInterfaceId.map(value => value),
        virtualInterfaceRegion.map(value => value),
        virtualInterfaceOwnerAccount.map(value => value),
        attachmentState.map(value => value),
        attachmentType.map(value => value),
        stateChangeError.map(value => value)
      )
    def directConnectGatewayId: Option[DirectConnectGatewayId]
    def virtualInterfaceId: Option[VirtualInterfaceId]
    def virtualInterfaceRegion: Option[VirtualInterfaceRegion]
    def virtualInterfaceOwnerAccount: Option[OwnerAccount]
    def attachmentState: Option[
      zio.aws.directconnect.model.DirectConnectGatewayAttachmentState
    ]
    def attachmentType
        : Option[zio.aws.directconnect.model.DirectConnectGatewayAttachmentType]
    def stateChangeError: Option[StateChangeError]
    def getDirectConnectGatewayId: ZIO[Any, AwsError, DirectConnectGatewayId] =
      AwsError.unwrapOptionField(
        "directConnectGatewayId",
        directConnectGatewayId
      )
    def getVirtualInterfaceId: ZIO[Any, AwsError, VirtualInterfaceId] =
      AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceId)
    def getVirtualInterfaceRegion: ZIO[Any, AwsError, VirtualInterfaceRegion] =
      AwsError.unwrapOptionField(
        "virtualInterfaceRegion",
        virtualInterfaceRegion
      )
    def getVirtualInterfaceOwnerAccount: ZIO[Any, AwsError, OwnerAccount] =
      AwsError.unwrapOptionField(
        "virtualInterfaceOwnerAccount",
        virtualInterfaceOwnerAccount
      )
    def getAttachmentState: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.DirectConnectGatewayAttachmentState
    ] = AwsError.unwrapOptionField("attachmentState", attachmentState)
    def getAttachmentType: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.DirectConnectGatewayAttachmentType
    ] = AwsError.unwrapOptionField("attachmentType", attachmentType)
    def getStateChangeError: ZIO[Any, AwsError, StateChangeError] =
      AwsError.unwrapOptionField("stateChangeError", stateChangeError)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment
  ) extends zio.aws.directconnect.model.DirectConnectGatewayAttachment.ReadOnly {
    override val directConnectGatewayId: Option[DirectConnectGatewayId] = scala
      .Option(impl.directConnectGatewayId())
      .map(value =>
        zio.aws.directconnect.model.primitives.DirectConnectGatewayId(value)
      )
    override val virtualInterfaceId: Option[VirtualInterfaceId] = scala
      .Option(impl.virtualInterfaceId())
      .map(value =>
        zio.aws.directconnect.model.primitives.VirtualInterfaceId(value)
      )
    override val virtualInterfaceRegion: Option[VirtualInterfaceRegion] = scala
      .Option(impl.virtualInterfaceRegion())
      .map(value =>
        zio.aws.directconnect.model.primitives.VirtualInterfaceRegion(value)
      )
    override val virtualInterfaceOwnerAccount: Option[OwnerAccount] = scala
      .Option(impl.virtualInterfaceOwnerAccount())
      .map(value => zio.aws.directconnect.model.primitives.OwnerAccount(value))
    override val attachmentState: Option[
      zio.aws.directconnect.model.DirectConnectGatewayAttachmentState
    ] = scala
      .Option(impl.attachmentState())
      .map(value =>
        zio.aws.directconnect.model.DirectConnectGatewayAttachmentState
          .wrap(value)
      )
    override val attachmentType: Option[
      zio.aws.directconnect.model.DirectConnectGatewayAttachmentType
    ] = scala
      .Option(impl.attachmentType())
      .map(value =>
        zio.aws.directconnect.model.DirectConnectGatewayAttachmentType
          .wrap(value)
      )
    override val stateChangeError: Option[StateChangeError] = scala
      .Option(impl.stateChangeError())
      .map(value =>
        zio.aws.directconnect.model.primitives.StateChangeError(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment
  ): zio.aws.directconnect.model.DirectConnectGatewayAttachment.ReadOnly =
    new Wrapper(impl)
}
