package zio.aws.directconnect.model
import scala.jdk.CollectionConverters._
sealed trait DirectConnectGatewayAssociationState {
  def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState
}
object DirectConnectGatewayAssociationState {
  def wrap(
      value: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState
  ): zio.aws.directconnect.model.DirectConnectGatewayAssociationState =
    value match {
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.ASSOCIATING =>
        val r = associating
        r
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.ASSOCIATED =>
        val r = associated
        r
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.DISASSOCIATING =>
        val r = disassociating
        r
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.DISASSOCIATED =>
        val r = disassociated
        r
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.UPDATING =>
        val r = updating
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.directconnect.model.DirectConnectGatewayAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.UNKNOWN_TO_SDK_VERSION
  }
  case object associating
      extends zio.aws.directconnect.model.DirectConnectGatewayAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.ASSOCIATING
  }
  case object associated
      extends zio.aws.directconnect.model.DirectConnectGatewayAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.ASSOCIATED
  }
  case object disassociating
      extends zio.aws.directconnect.model.DirectConnectGatewayAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.DISASSOCIATING
  }
  case object disassociated
      extends zio.aws.directconnect.model.DirectConnectGatewayAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.DISASSOCIATED
  }
  case object updating
      extends zio.aws.directconnect.model.DirectConnectGatewayAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.UPDATING
  }
}
