package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVirtualGatewaysResponse(
    virtualGateways: Option[
      Iterable[zio.aws.directconnect.model.VirtualGateway]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysResponse = {
    import DescribeVirtualGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysResponse
      .builder()
      .optionallyWith(
        virtualGateways.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.virtualGateways)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeVirtualGatewaysResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeVirtualGatewaysResponse
      .wrap(buildAwsValue())
}
object DescribeVirtualGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeVirtualGatewaysResponse =
      zio.aws.directconnect.model.DescribeVirtualGatewaysResponse(
        virtualGateways.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def virtualGateways
        : Option[List[zio.aws.directconnect.model.VirtualGateway.ReadOnly]]
    def getVirtualGateways: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.VirtualGateway.ReadOnly
    ]] = AwsError.unwrapOptionField("virtualGateways", virtualGateways)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysResponse
  ) extends zio.aws.directconnect.model.DescribeVirtualGatewaysResponse.ReadOnly {
    override val virtualGateways
        : Option[List[zio.aws.directconnect.model.VirtualGateway.ReadOnly]] =
      scala
        .Option(impl.virtualGateways())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.VirtualGateway.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysResponse
  ): zio.aws.directconnect.model.DescribeVirtualGatewaysResponse.ReadOnly =
    new Wrapper(impl)
}
