package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.LagId
import scala.jdk.CollectionConverters._
final case class DescribeLagsRequest(lagId: Option[LagId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest = {
    import DescribeLagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest
      .builder()
      .optionallyWith(
        lagId.map(value => LagId.unwrap(value): java.lang.String)
      )(_.lagId)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.DescribeLagsRequest.ReadOnly =
    zio.aws.directconnect.model.DescribeLagsRequest.wrap(buildAwsValue())
}
object DescribeLagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DescribeLagsRequest =
      zio.aws.directconnect.model.DescribeLagsRequest(lagId.map(value => value))
    def lagId: Option[LagId]
    def getLagId: ZIO[Any, AwsError, LagId] =
      AwsError.unwrapOptionField("lagId", lagId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest
  ) extends zio.aws.directconnect.model.DescribeLagsRequest.ReadOnly {
    override val lagId: Option[LagId] = scala
      .Option(impl.lagId())
      .map(value => zio.aws.directconnect.model.primitives.LagId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest
  ): zio.aws.directconnect.model.DescribeLagsRequest.ReadOnly = new Wrapper(
    impl
  )
}
