package zio.aws.directconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  PaginationToken,
  MaxResultSetSize,
  DirectConnectGatewayId
}
import scala.jdk.CollectionConverters._
final case class DescribeDirectConnectGatewaysRequest(
    directConnectGatewayId: Option[DirectConnectGatewayId] = None,
    maxResults: Option[MaxResultSetSize] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest = {
    import DescribeDirectConnectGatewaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest
      .builder()
      .optionallyWith(
        directConnectGatewayId.map(value =>
          DirectConnectGatewayId.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayId)
      .optionallyWith(
        maxResults.map(value => MaxResultSetSize.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeDirectConnectGatewaysRequest.ReadOnly =
    zio.aws.directconnect.model.DescribeDirectConnectGatewaysRequest
      .wrap(buildAwsValue())
}
object DescribeDirectConnectGatewaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeDirectConnectGatewaysRequest =
      zio.aws.directconnect.model.DescribeDirectConnectGatewaysRequest(
        directConnectGatewayId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def directConnectGatewayId: Option[DirectConnectGatewayId]
    def maxResults: Option[MaxResultSetSize]
    def nextToken: Option[PaginationToken]
    def getDirectConnectGatewayId: ZIO[Any, AwsError, DirectConnectGatewayId] =
      AwsError.unwrapOptionField(
        "directConnectGatewayId",
        directConnectGatewayId
      )
    def getMaxResults: ZIO[Any, AwsError, MaxResultSetSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest
  ) extends zio.aws.directconnect.model.DescribeDirectConnectGatewaysRequest.ReadOnly {
    override val directConnectGatewayId: Option[DirectConnectGatewayId] = scala
      .Option(impl.directConnectGatewayId())
      .map(value =>
        zio.aws.directconnect.model.primitives.DirectConnectGatewayId(value)
      )
    override val maxResults: Option[MaxResultSetSize] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.directconnect.model.primitives.MaxResultSetSize(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.directconnect.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest
  ): zio.aws.directconnect.model.DescribeDirectConnectGatewaysRequest.ReadOnly =
    new Wrapper(impl)
}
