package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class DescribeDirectConnectGatewayAttachmentsResponse(
    directConnectGatewayAttachments: Option[
      Iterable[zio.aws.directconnect.model.DirectConnectGatewayAttachment]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse = {
    import DescribeDirectConnectGatewayAttachmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse
      .builder()
      .optionallyWith(
        directConnectGatewayAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.directConnectGatewayAttachments)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse
      .wrap(buildAwsValue())
}
object DescribeDirectConnectGatewayAttachmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse =
      zio.aws.directconnect.model
        .DescribeDirectConnectGatewayAttachmentsResponse(
          directConnectGatewayAttachments.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def directConnectGatewayAttachments: Option[
      List[zio.aws.directconnect.model.DirectConnectGatewayAttachment.ReadOnly]
    ]
    def nextToken: Option[PaginationToken]
    def getDirectConnectGatewayAttachments: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.DirectConnectGatewayAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "directConnectGatewayAttachments",
      directConnectGatewayAttachments
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse
  ) extends zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse.ReadOnly {
    override val directConnectGatewayAttachments: Option[
      List[zio.aws.directconnect.model.DirectConnectGatewayAttachment.ReadOnly]
    ] = scala
      .Option(impl.directConnectGatewayAttachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.DirectConnectGatewayAttachment.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.directconnect.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse
  ): zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse.ReadOnly =
    new Wrapper(impl)
}
