package zio.aws.directconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  DirectConnectGatewayId,
  AssociatedGatewayId,
  PaginationToken,
  VirtualGatewayId,
  MaxResultSetSize,
  DirectConnectGatewayAssociationId
}
import scala.jdk.CollectionConverters._
final case class DescribeDirectConnectGatewayAssociationsRequest(
    associationId: Option[DirectConnectGatewayAssociationId] = None,
    associatedGatewayId: Option[AssociatedGatewayId] = None,
    directConnectGatewayId: Option[DirectConnectGatewayId] = None,
    maxResults: Option[MaxResultSetSize] = None,
    nextToken: Option[PaginationToken] = None,
    virtualGatewayId: Option[VirtualGatewayId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest = {
    import DescribeDirectConnectGatewayAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest
      .builder()
      .optionallyWith(
        associationId.map(value =>
          DirectConnectGatewayAssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        associatedGatewayId.map(value =>
          AssociatedGatewayId.unwrap(value): java.lang.String
        )
      )(_.associatedGatewayId)
      .optionallyWith(
        directConnectGatewayId.map(value =>
          DirectConnectGatewayId.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayId)
      .optionallyWith(
        maxResults.map(value => MaxResultSetSize.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        virtualGatewayId.map(value =>
          VirtualGatewayId.unwrap(value): java.lang.String
        )
      )(_.virtualGatewayId)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest.ReadOnly =
    zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeDirectConnectGatewayAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest =
      zio.aws.directconnect.model
        .DescribeDirectConnectGatewayAssociationsRequest(
          associationId.map(value => value),
          associatedGatewayId.map(value => value),
          directConnectGatewayId.map(value => value),
          maxResults.map(value => value),
          nextToken.map(value => value),
          virtualGatewayId.map(value => value)
        )
    def associationId: Option[DirectConnectGatewayAssociationId]
    def associatedGatewayId: Option[AssociatedGatewayId]
    def directConnectGatewayId: Option[DirectConnectGatewayId]
    def maxResults: Option[MaxResultSetSize]
    def nextToken: Option[PaginationToken]
    def virtualGatewayId: Option[VirtualGatewayId]
    def getAssociationId
        : ZIO[Any, AwsError, DirectConnectGatewayAssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getAssociatedGatewayId: ZIO[Any, AwsError, AssociatedGatewayId] =
      AwsError.unwrapOptionField("associatedGatewayId", associatedGatewayId)
    def getDirectConnectGatewayId: ZIO[Any, AwsError, DirectConnectGatewayId] =
      AwsError.unwrapOptionField(
        "directConnectGatewayId",
        directConnectGatewayId
      )
    def getMaxResults: ZIO[Any, AwsError, MaxResultSetSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVirtualGatewayId: ZIO[Any, AwsError, VirtualGatewayId] =
      AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest
  ) extends zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest.ReadOnly {
    override val associationId: Option[DirectConnectGatewayAssociationId] =
      scala
        .Option(impl.associationId())
        .map(value =>
          zio.aws.directconnect.model.primitives
            .DirectConnectGatewayAssociationId(value)
        )
    override val associatedGatewayId: Option[AssociatedGatewayId] = scala
      .Option(impl.associatedGatewayId())
      .map(value =>
        zio.aws.directconnect.model.primitives.AssociatedGatewayId(value)
      )
    override val directConnectGatewayId: Option[DirectConnectGatewayId] = scala
      .Option(impl.directConnectGatewayId())
      .map(value =>
        zio.aws.directconnect.model.primitives.DirectConnectGatewayId(value)
      )
    override val maxResults: Option[MaxResultSetSize] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.directconnect.model.primitives.MaxResultSetSize(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.directconnect.model.primitives.PaginationToken(value)
      )
    override val virtualGatewayId: Option[VirtualGatewayId] = scala
      .Option(impl.virtualGatewayId())
      .map(value =>
        zio.aws.directconnect.model.primitives.VirtualGatewayId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest
  ): zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
