package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.ConnectionId
import scala.jdk.CollectionConverters._
final case class DescribeConnectionsRequest(
    connectionId: Option[ConnectionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest = {
    import DescribeConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest
      .builder()
      .optionallyWith(
        connectionId.map(value => ConnectionId.unwrap(value): java.lang.String)
      )(_.connectionId)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeConnectionsRequest.ReadOnly =
    zio.aws.directconnect.model.DescribeConnectionsRequest.wrap(buildAwsValue())
}
object DescribeConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DescribeConnectionsRequest =
      zio.aws.directconnect.model
        .DescribeConnectionsRequest(connectionId.map(value => value))
    def connectionId: Option[ConnectionId]
    def getConnectionId: ZIO[Any, AwsError, ConnectionId] =
      AwsError.unwrapOptionField("connectionId", connectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest
  ) extends zio.aws.directconnect.model.DescribeConnectionsRequest.ReadOnly {
    override val connectionId: Option[ConnectionId] = scala
      .Option(impl.connectionId())
      .map(value => zio.aws.directconnect.model.primitives.ConnectionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest
  ): zio.aws.directconnect.model.DescribeConnectionsRequest.ReadOnly =
    new Wrapper(impl)
}
