package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{Status, AgreementName}
import scala.jdk.CollectionConverters._
final case class CustomerAgreement(
    agreementName: Option[AgreementName] = None,
    status: Option[Status] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.CustomerAgreement = {
    import CustomerAgreement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.CustomerAgreement
      .builder()
      .optionallyWith(
        agreementName.map(value =>
          AgreementName.unwrap(value): java.lang.String
        )
      )(_.agreementName)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.CustomerAgreement.ReadOnly =
    zio.aws.directconnect.model.CustomerAgreement.wrap(buildAwsValue())
}
object CustomerAgreement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.CustomerAgreement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.CustomerAgreement =
      zio.aws.directconnect.model.CustomerAgreement(
        agreementName.map(value => value),
        status.map(value => value)
      )
    def agreementName: Option[AgreementName]
    def status: Option[Status]
    def getAgreementName: ZIO[Any, AwsError, AgreementName] =
      AwsError.unwrapOptionField("agreementName", agreementName)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.CustomerAgreement
  ) extends zio.aws.directconnect.model.CustomerAgreement.ReadOnly {
    override val agreementName: Option[AgreementName] = scala
      .Option(impl.agreementName())
      .map(value => zio.aws.directconnect.model.primitives.AgreementName(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.directconnect.model.primitives.Status(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.CustomerAgreement
  ): zio.aws.directconnect.model.CustomerAgreement.ReadOnly = new Wrapper(impl)
}
