package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDirectConnectGatewayResponse(
    directConnectGateway: Option[
      zio.aws.directconnect.model.DirectConnectGateway
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayResponse = {
    import CreateDirectConnectGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayResponse
      .builder()
      .optionallyWith(directConnectGateway.map(value => value.buildAwsValue()))(
        _.directConnectGateway
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.CreateDirectConnectGatewayResponse.ReadOnly =
    zio.aws.directconnect.model.CreateDirectConnectGatewayResponse
      .wrap(buildAwsValue())
}
object CreateDirectConnectGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.CreateDirectConnectGatewayResponse =
      zio.aws.directconnect.model.CreateDirectConnectGatewayResponse(
        directConnectGateway.map(value => value.asEditable)
      )
    def directConnectGateway
        : Option[zio.aws.directconnect.model.DirectConnectGateway.ReadOnly]
    def getDirectConnectGateway: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.DirectConnectGateway.ReadOnly
    ] = AwsError.unwrapOptionField("directConnectGateway", directConnectGateway)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayResponse
  ) extends zio.aws.directconnect.model.CreateDirectConnectGatewayResponse.ReadOnly {
    override val directConnectGateway
        : Option[zio.aws.directconnect.model.DirectConnectGateway.ReadOnly] =
      scala
        .Option(impl.directConnectGateway())
        .map(value =>
          zio.aws.directconnect.model.DirectConnectGateway.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayResponse
  ): zio.aws.directconnect.model.CreateDirectConnectGatewayResponse.ReadOnly =
    new Wrapper(impl)
}
