package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  ProviderName,
  ConnectionName,
  Bandwidth,
  RequestMACSec,
  LagId,
  LocationCode
}
import scala.jdk.CollectionConverters._
final case class CreateConnectionRequest(
    location: LocationCode,
    bandwidth: Bandwidth,
    connectionName: ConnectionName,
    lagId: Option[LagId] = None,
    tags: Option[Iterable[zio.aws.directconnect.model.Tag]] = None,
    providerName: Option[ProviderName] = None,
    requestMACSec: Option[RequestMACSec] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest = {
    import CreateConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest
      .builder()
      .location(LocationCode.unwrap(location): java.lang.String)
      .bandwidth(Bandwidth.unwrap(bandwidth): java.lang.String)
      .connectionName(ConnectionName.unwrap(connectionName): java.lang.String)
      .optionallyWith(
        lagId.map(value => LagId.unwrap(value): java.lang.String)
      )(_.lagId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        providerName.map(value => ProviderName.unwrap(value): java.lang.String)
      )(_.providerName)
      .optionallyWith(
        requestMACSec.map(value =>
          RequestMACSec.unwrap(value): java.lang.Boolean
        )
      )(_.requestMACSec)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.CreateConnectionRequest.ReadOnly =
    zio.aws.directconnect.model.CreateConnectionRequest.wrap(buildAwsValue())
}
object CreateConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.CreateConnectionRequest =
      zio.aws.directconnect.model.CreateConnectionRequest(
        location,
        bandwidth,
        connectionName,
        lagId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        providerName.map(value => value),
        requestMACSec.map(value => value)
      )
    def location: LocationCode
    def bandwidth: Bandwidth
    def connectionName: ConnectionName
    def lagId: Option[LagId]
    def tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def providerName: Option[ProviderName]
    def requestMACSec: Option[RequestMACSec]
    def getLocation: ZIO[Any, Nothing, LocationCode] = ZIO.succeed(location)
    def getBandwidth: ZIO[Any, Nothing, Bandwidth] = ZIO.succeed(bandwidth)
    def getConnectionName: ZIO[Any, Nothing, ConnectionName] =
      ZIO.succeed(connectionName)
    def getLagId: ZIO[Any, AwsError, LagId] =
      AwsError.unwrapOptionField("lagId", lagId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getProviderName: ZIO[Any, AwsError, ProviderName] =
      AwsError.unwrapOptionField("providerName", providerName)
    def getRequestMACSec: ZIO[Any, AwsError, RequestMACSec] =
      AwsError.unwrapOptionField("requestMACSec", requestMACSec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest
  ) extends zio.aws.directconnect.model.CreateConnectionRequest.ReadOnly {
    override val location: LocationCode =
      zio.aws.directconnect.model.primitives.LocationCode(impl.location())
    override val bandwidth: Bandwidth =
      zio.aws.directconnect.model.primitives.Bandwidth(impl.bandwidth())
    override val connectionName: ConnectionName =
      zio.aws.directconnect.model.primitives
        .ConnectionName(impl.connectionName())
    override val lagId: Option[LagId] = scala
      .Option(impl.lagId())
      .map(value => zio.aws.directconnect.model.primitives.LagId(value))
    override val tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
    override val providerName: Option[ProviderName] = scala
      .Option(impl.providerName())
      .map(value => zio.aws.directconnect.model.primitives.ProviderName(value))
    override val requestMACSec: Option[RequestMACSec] = scala
      .Option(impl.requestMACSec())
      .map(value => zio.aws.directconnect.model.primitives.RequestMACSec(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest
  ): zio.aws.directconnect.model.CreateConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
