package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.VirtualInterfaceId
import scala.jdk.CollectionConverters._
final case class CreateBgpPeerRequest(
    virtualInterfaceId: Option[VirtualInterfaceId] = None,
    newBGPPeer: Option[zio.aws.directconnect.model.NewBGPPeer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.CreateBgpPeerRequest = {
    import CreateBgpPeerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.CreateBgpPeerRequest
      .builder()
      .optionallyWith(
        virtualInterfaceId.map(value =>
          VirtualInterfaceId.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceId)
      .optionallyWith(newBGPPeer.map(value => value.buildAwsValue()))(
        _.newBGPPeer
      )
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.CreateBgpPeerRequest.ReadOnly =
    zio.aws.directconnect.model.CreateBgpPeerRequest.wrap(buildAwsValue())
}
object CreateBgpPeerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.CreateBgpPeerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.CreateBgpPeerRequest =
      zio.aws.directconnect.model.CreateBgpPeerRequest(
        virtualInterfaceId.map(value => value),
        newBGPPeer.map(value => value.asEditable)
      )
    def virtualInterfaceId: Option[VirtualInterfaceId]
    def newBGPPeer: Option[zio.aws.directconnect.model.NewBGPPeer.ReadOnly]
    def getVirtualInterfaceId: ZIO[Any, AwsError, VirtualInterfaceId] =
      AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceId)
    def getNewBGPPeer
        : ZIO[Any, AwsError, zio.aws.directconnect.model.NewBGPPeer.ReadOnly] =
      AwsError.unwrapOptionField("newBGPPeer", newBGPPeer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.CreateBgpPeerRequest
  ) extends zio.aws.directconnect.model.CreateBgpPeerRequest.ReadOnly {
    override val virtualInterfaceId: Option[VirtualInterfaceId] = scala
      .Option(impl.virtualInterfaceId())
      .map(value =>
        zio.aws.directconnect.model.primitives.VirtualInterfaceId(value)
      )
    override val newBGPPeer
        : Option[zio.aws.directconnect.model.NewBGPPeer.ReadOnly] = scala
      .Option(impl.newBGPPeer())
      .map(value => zio.aws.directconnect.model.NewBGPPeer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.CreateBgpPeerRequest
  ): zio.aws.directconnect.model.CreateBgpPeerRequest.ReadOnly = new Wrapper(
    impl
  )
}
