package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConfirmPublicVirtualInterfaceResponse(
    virtualInterfaceState: Option[
      zio.aws.directconnect.model.VirtualInterfaceState
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse = {
    import ConfirmPublicVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse
      .builder()
      .optionallyWith(virtualInterfaceState.map(value => value.unwrap))(
        _.virtualInterfaceState
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceResponse.ReadOnly =
    zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceResponse
      .wrap(buildAwsValue())
}
object ConfirmPublicVirtualInterfaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceResponse =
      zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceResponse(
        virtualInterfaceState.map(value => value)
      )
    def virtualInterfaceState
        : Option[zio.aws.directconnect.model.VirtualInterfaceState]
    def getVirtualInterfaceState: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.VirtualInterfaceState
    ] =
      AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse
  ) extends zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceResponse.ReadOnly {
    override val virtualInterfaceState
        : Option[zio.aws.directconnect.model.VirtualInterfaceState] = scala
      .Option(impl.virtualInterfaceState())
      .map(value =>
        zio.aws.directconnect.model.VirtualInterfaceState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse
  ): zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceResponse.ReadOnly =
    new Wrapper(impl)
}
