package zio.aws.directconnect.model
import scala.jdk.CollectionConverters._
sealed trait BGPPeerState {
  def unwrap: software.amazon.awssdk.services.directconnect.model.BGPPeerState
}
object BGPPeerState {
  def wrap(
      value: software.amazon.awssdk.services.directconnect.model.BGPPeerState
  ): zio.aws.directconnect.model.BGPPeerState = value match {
    case software.amazon.awssdk.services.directconnect.model.BGPPeerState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.directconnect.model.BGPPeerState.VERIFYING =>
      val r = verifying
      r
    case software.amazon.awssdk.services.directconnect.model.BGPPeerState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.directconnect.model.BGPPeerState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.directconnect.model.BGPPeerState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.directconnect.model.BGPPeerState.DELETED =>
      val r = deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.directconnect.model.BGPPeerState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.BGPPeerState =
      software.amazon.awssdk.services.directconnect.model.BGPPeerState.UNKNOWN_TO_SDK_VERSION
  }
  case object verifying extends zio.aws.directconnect.model.BGPPeerState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.BGPPeerState =
      software.amazon.awssdk.services.directconnect.model.BGPPeerState.VERIFYING
  }
  case object pending extends zio.aws.directconnect.model.BGPPeerState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.BGPPeerState =
      software.amazon.awssdk.services.directconnect.model.BGPPeerState.PENDING
  }
  case object available extends zio.aws.directconnect.model.BGPPeerState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.BGPPeerState =
      software.amazon.awssdk.services.directconnect.model.BGPPeerState.AVAILABLE
  }
  case object deleting extends zio.aws.directconnect.model.BGPPeerState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.BGPPeerState =
      software.amazon.awssdk.services.directconnect.model.BGPPeerState.DELETING
  }
  case object deleted extends zio.aws.directconnect.model.BGPPeerState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.BGPPeerState =
      software.amazon.awssdk.services.directconnect.model.BGPPeerState.DELETED
  }
}
