package zio.aws.directconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  DirectConnectGatewayId,
  VLAN,
  VirtualInterfaceName,
  OwnerAccount,
  VirtualInterfaceType,
  ConnectionId,
  MTU,
  RouterConfig,
  AwsDeviceV2,
  LongAsn,
  BGPAuthKey,
  Region,
  VirtualGatewayId,
  AwsLogicalDeviceId,
  VirtualInterfaceId,
  JumboFrameCapable,
  SiteLinkEnabled,
  ASN,
  AmazonAddress,
  LocationCode,
  CustomerAddress
}
import scala.jdk.CollectionConverters._
final case class AssociateVirtualInterfaceResponse(
    ownerAccount: Option[OwnerAccount] = None,
    virtualInterfaceId: Option[VirtualInterfaceId] = None,
    location: Option[LocationCode] = None,
    connectionId: Option[ConnectionId] = None,
    virtualInterfaceType: Option[VirtualInterfaceType] = None,
    virtualInterfaceName: Option[VirtualInterfaceName] = None,
    vlan: Option[VLAN] = None,
    asn: Option[ASN] = None,
    amazonSideAsn: Option[LongAsn] = None,
    authKey: Option[BGPAuthKey] = None,
    amazonAddress: Option[AmazonAddress] = None,
    customerAddress: Option[CustomerAddress] = None,
    addressFamily: Option[zio.aws.directconnect.model.AddressFamily] = None,
    virtualInterfaceState: Option[
      zio.aws.directconnect.model.VirtualInterfaceState
    ] = None,
    customerRouterConfig: Option[RouterConfig] = None,
    mtu: Option[MTU] = None,
    jumboFrameCapable: Option[JumboFrameCapable] = None,
    virtualGatewayId: Option[VirtualGatewayId] = None,
    directConnectGatewayId: Option[DirectConnectGatewayId] = None,
    routeFilterPrefixes: Option[
      Iterable[zio.aws.directconnect.model.RouteFilterPrefix]
    ] = None,
    bgpPeers: Option[Iterable[zio.aws.directconnect.model.BGPPeer]] = None,
    region: Option[Region] = None,
    awsDeviceV2: Option[AwsDeviceV2] = None,
    awsLogicalDeviceId: Option[AwsLogicalDeviceId] = None,
    tags: Option[Iterable[zio.aws.directconnect.model.Tag]] = None,
    siteLinkEnabled: Option[SiteLinkEnabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceResponse = {
    import AssociateVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceResponse
      .builder()
      .optionallyWith(
        ownerAccount.map(value => OwnerAccount.unwrap(value): java.lang.String)
      )(_.ownerAccount)
      .optionallyWith(
        virtualInterfaceId.map(value =>
          VirtualInterfaceId.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceId)
      .optionallyWith(
        location.map(value => LocationCode.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(
        connectionId.map(value => ConnectionId.unwrap(value): java.lang.String)
      )(_.connectionId)
      .optionallyWith(
        virtualInterfaceType.map(value =>
          VirtualInterfaceType.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceType)
      .optionallyWith(
        virtualInterfaceName.map(value =>
          VirtualInterfaceName.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceName)
      .optionallyWith(vlan.map(value => VLAN.unwrap(value): Integer))(_.vlan)
      .optionallyWith(asn.map(value => ASN.unwrap(value): Integer))(_.asn)
      .optionallyWith(
        amazonSideAsn.map(value => LongAsn.unwrap(value): java.lang.Long)
      )(_.amazonSideAsn)
      .optionallyWith(
        authKey.map(value => BGPAuthKey.unwrap(value): java.lang.String)
      )(_.authKey)
      .optionallyWith(
        amazonAddress.map(value =>
          AmazonAddress.unwrap(value): java.lang.String
        )
      )(_.amazonAddress)
      .optionallyWith(
        customerAddress.map(value =>
          CustomerAddress.unwrap(value): java.lang.String
        )
      )(_.customerAddress)
      .optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily)
      .optionallyWith(virtualInterfaceState.map(value => value.unwrap))(
        _.virtualInterfaceState
      )
      .optionallyWith(
        customerRouterConfig.map(value =>
          RouterConfig.unwrap(value): java.lang.String
        )
      )(_.customerRouterConfig)
      .optionallyWith(mtu.map(value => MTU.unwrap(value): Integer))(_.mtu)
      .optionallyWith(
        jumboFrameCapable.map(value =>
          JumboFrameCapable.unwrap(value): java.lang.Boolean
        )
      )(_.jumboFrameCapable)
      .optionallyWith(
        virtualGatewayId.map(value =>
          VirtualGatewayId.unwrap(value): java.lang.String
        )
      )(_.virtualGatewayId)
      .optionallyWith(
        directConnectGatewayId.map(value =>
          DirectConnectGatewayId.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayId)
      .optionallyWith(
        routeFilterPrefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routeFilterPrefixes)
      .optionallyWith(
        bgpPeers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bgpPeers)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        awsDeviceV2.map(value => AwsDeviceV2.unwrap(value): java.lang.String)
      )(_.awsDeviceV2)
      .optionallyWith(
        awsLogicalDeviceId.map(value =>
          AwsLogicalDeviceId.unwrap(value): java.lang.String
        )
      )(_.awsLogicalDeviceId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        siteLinkEnabled.map(value =>
          SiteLinkEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.siteLinkEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.AssociateVirtualInterfaceResponse.ReadOnly =
    zio.aws.directconnect.model.AssociateVirtualInterfaceResponse
      .wrap(buildAwsValue())
}
object AssociateVirtualInterfaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.AssociateVirtualInterfaceResponse =
      zio.aws.directconnect.model.AssociateVirtualInterfaceResponse(
        ownerAccount.map(value => value),
        virtualInterfaceId.map(value => value),
        location.map(value => value),
        connectionId.map(value => value),
        virtualInterfaceType.map(value => value),
        virtualInterfaceName.map(value => value),
        vlan.map(value => value),
        asn.map(value => value),
        amazonSideAsn.map(value => value),
        authKey.map(value => value),
        amazonAddress.map(value => value),
        customerAddress.map(value => value),
        addressFamily.map(value => value),
        virtualInterfaceState.map(value => value),
        customerRouterConfig.map(value => value),
        mtu.map(value => value),
        jumboFrameCapable.map(value => value),
        virtualGatewayId.map(value => value),
        directConnectGatewayId.map(value => value),
        routeFilterPrefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        bgpPeers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        region.map(value => value),
        awsDeviceV2.map(value => value),
        awsLogicalDeviceId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        siteLinkEnabled.map(value => value)
      )
    def ownerAccount: Option[OwnerAccount]
    def virtualInterfaceId: Option[VirtualInterfaceId]
    def location: Option[LocationCode]
    def connectionId: Option[ConnectionId]
    def virtualInterfaceType: Option[VirtualInterfaceType]
    def virtualInterfaceName: Option[VirtualInterfaceName]
    def vlan: Option[VLAN]
    def asn: Option[ASN]
    def amazonSideAsn: Option[LongAsn]
    def authKey: Option[BGPAuthKey]
    def amazonAddress: Option[AmazonAddress]
    def customerAddress: Option[CustomerAddress]
    def addressFamily: Option[zio.aws.directconnect.model.AddressFamily]
    def virtualInterfaceState
        : Option[zio.aws.directconnect.model.VirtualInterfaceState]
    def customerRouterConfig: Option[RouterConfig]
    def mtu: Option[MTU]
    def jumboFrameCapable: Option[JumboFrameCapable]
    def virtualGatewayId: Option[VirtualGatewayId]
    def directConnectGatewayId: Option[DirectConnectGatewayId]
    def routeFilterPrefixes
        : Option[List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]]
    def bgpPeers: Option[List[zio.aws.directconnect.model.BGPPeer.ReadOnly]]
    def region: Option[Region]
    def awsDeviceV2: Option[AwsDeviceV2]
    def awsLogicalDeviceId: Option[AwsLogicalDeviceId]
    def tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def siteLinkEnabled: Option[SiteLinkEnabled]
    def getOwnerAccount: ZIO[Any, AwsError, OwnerAccount] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getVirtualInterfaceId: ZIO[Any, AwsError, VirtualInterfaceId] =
      AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceId)
    def getLocation: ZIO[Any, AwsError, LocationCode] =
      AwsError.unwrapOptionField("location", location)
    def getConnectionId: ZIO[Any, AwsError, ConnectionId] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getVirtualInterfaceType: ZIO[Any, AwsError, VirtualInterfaceType] =
      AwsError.unwrapOptionField("virtualInterfaceType", virtualInterfaceType)
    def getVirtualInterfaceName: ZIO[Any, AwsError, VirtualInterfaceName] =
      AwsError.unwrapOptionField("virtualInterfaceName", virtualInterfaceName)
    def getVlan: ZIO[Any, AwsError, VLAN] =
      AwsError.unwrapOptionField("vlan", vlan)
    def getAsn: ZIO[Any, AwsError, ASN] = AwsError.unwrapOptionField("asn", asn)
    def getAmazonSideAsn: ZIO[Any, AwsError, LongAsn] =
      AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsn)
    def getAuthKey: ZIO[Any, AwsError, BGPAuthKey] =
      AwsError.unwrapOptionField("authKey", authKey)
    def getAmazonAddress: ZIO[Any, AwsError, AmazonAddress] =
      AwsError.unwrapOptionField("amazonAddress", amazonAddress)
    def getCustomerAddress: ZIO[Any, AwsError, CustomerAddress] =
      AwsError.unwrapOptionField("customerAddress", customerAddress)
    def getAddressFamily
        : ZIO[Any, AwsError, zio.aws.directconnect.model.AddressFamily] =
      AwsError.unwrapOptionField("addressFamily", addressFamily)
    def getVirtualInterfaceState: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.VirtualInterfaceState
    ] =
      AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceState)
    def getCustomerRouterConfig: ZIO[Any, AwsError, RouterConfig] =
      AwsError.unwrapOptionField("customerRouterConfig", customerRouterConfig)
    def getMtu: ZIO[Any, AwsError, MTU] = AwsError.unwrapOptionField("mtu", mtu)
    def getJumboFrameCapable: ZIO[Any, AwsError, JumboFrameCapable] =
      AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapable)
    def getVirtualGatewayId: ZIO[Any, AwsError, VirtualGatewayId] =
      AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayId)
    def getDirectConnectGatewayId: ZIO[Any, AwsError, DirectConnectGatewayId] =
      AwsError.unwrapOptionField(
        "directConnectGatewayId",
        directConnectGatewayId
      )
    def getRouteFilterPrefixes: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly
    ]] = AwsError.unwrapOptionField("routeFilterPrefixes", routeFilterPrefixes)
    def getBgpPeers: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.BGPPeer.ReadOnly
    ]] = AwsError.unwrapOptionField("bgpPeers", bgpPeers)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getAwsDeviceV2: ZIO[Any, AwsError, AwsDeviceV2] =
      AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2)
    def getAwsLogicalDeviceId: ZIO[Any, AwsError, AwsLogicalDeviceId] =
      AwsError.unwrapOptionField("awsLogicalDeviceId", awsLogicalDeviceId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSiteLinkEnabled: ZIO[Any, AwsError, SiteLinkEnabled] =
      AwsError.unwrapOptionField("siteLinkEnabled", siteLinkEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceResponse
  ) extends zio.aws.directconnect.model.AssociateVirtualInterfaceResponse.ReadOnly {
    override val ownerAccount: Option[OwnerAccount] = scala
      .Option(impl.ownerAccount())
      .map(value => zio.aws.directconnect.model.primitives.OwnerAccount(value))
    override val virtualInterfaceId: Option[VirtualInterfaceId] = scala
      .Option(impl.virtualInterfaceId())
      .map(value =>
        zio.aws.directconnect.model.primitives.VirtualInterfaceId(value)
      )
    override val location: Option[LocationCode] = scala
      .Option(impl.location())
      .map(value => zio.aws.directconnect.model.primitives.LocationCode(value))
    override val connectionId: Option[ConnectionId] = scala
      .Option(impl.connectionId())
      .map(value => zio.aws.directconnect.model.primitives.ConnectionId(value))
    override val virtualInterfaceType: Option[VirtualInterfaceType] = scala
      .Option(impl.virtualInterfaceType())
      .map(value =>
        zio.aws.directconnect.model.primitives.VirtualInterfaceType(value)
      )
    override val virtualInterfaceName: Option[VirtualInterfaceName] = scala
      .Option(impl.virtualInterfaceName())
      .map(value =>
        zio.aws.directconnect.model.primitives.VirtualInterfaceName(value)
      )
    override val vlan: Option[VLAN] = scala
      .Option(impl.vlan())
      .map(value => zio.aws.directconnect.model.primitives.VLAN(value))
    override val asn: Option[ASN] = scala
      .Option(impl.asn())
      .map(value => zio.aws.directconnect.model.primitives.ASN(value))
    override val amazonSideAsn: Option[LongAsn] = scala
      .Option(impl.amazonSideAsn())
      .map(value => zio.aws.directconnect.model.primitives.LongAsn(value))
    override val authKey: Option[BGPAuthKey] = scala
      .Option(impl.authKey())
      .map(value => zio.aws.directconnect.model.primitives.BGPAuthKey(value))
    override val amazonAddress: Option[AmazonAddress] = scala
      .Option(impl.amazonAddress())
      .map(value => zio.aws.directconnect.model.primitives.AmazonAddress(value))
    override val customerAddress: Option[CustomerAddress] = scala
      .Option(impl.customerAddress())
      .map(value =>
        zio.aws.directconnect.model.primitives.CustomerAddress(value)
      )
    override val addressFamily
        : Option[zio.aws.directconnect.model.AddressFamily] = scala
      .Option(impl.addressFamily())
      .map(value => zio.aws.directconnect.model.AddressFamily.wrap(value))
    override val virtualInterfaceState
        : Option[zio.aws.directconnect.model.VirtualInterfaceState] = scala
      .Option(impl.virtualInterfaceState())
      .map(value =>
        zio.aws.directconnect.model.VirtualInterfaceState.wrap(value)
      )
    override val customerRouterConfig: Option[RouterConfig] = scala
      .Option(impl.customerRouterConfig())
      .map(value => zio.aws.directconnect.model.primitives.RouterConfig(value))
    override val mtu: Option[MTU] = scala
      .Option(impl.mtu())
      .map(value => zio.aws.directconnect.model.primitives.MTU(value))
    override val jumboFrameCapable: Option[JumboFrameCapable] = scala
      .Option(impl.jumboFrameCapable())
      .map(value =>
        zio.aws.directconnect.model.primitives.JumboFrameCapable(value)
      )
    override val virtualGatewayId: Option[VirtualGatewayId] = scala
      .Option(impl.virtualGatewayId())
      .map(value =>
        zio.aws.directconnect.model.primitives.VirtualGatewayId(value)
      )
    override val directConnectGatewayId: Option[DirectConnectGatewayId] = scala
      .Option(impl.directConnectGatewayId())
      .map(value =>
        zio.aws.directconnect.model.primitives.DirectConnectGatewayId(value)
      )
    override val routeFilterPrefixes
        : Option[List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]] =
      scala
        .Option(impl.routeFilterPrefixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.RouteFilterPrefix.wrap(item)
          }.toList
        )
    override val bgpPeers
        : Option[List[zio.aws.directconnect.model.BGPPeer.ReadOnly]] = scala
      .Option(impl.bgpPeers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.BGPPeer.wrap(item)
        }.toList
      )
    override val region: Option[Region] = scala
      .Option(impl.region())
      .map(value => zio.aws.directconnect.model.primitives.Region(value))
    override val awsDeviceV2: Option[AwsDeviceV2] = scala
      .Option(impl.awsDeviceV2())
      .map(value => zio.aws.directconnect.model.primitives.AwsDeviceV2(value))
    override val awsLogicalDeviceId: Option[AwsLogicalDeviceId] = scala
      .Option(impl.awsLogicalDeviceId())
      .map(value =>
        zio.aws.directconnect.model.primitives.AwsLogicalDeviceId(value)
      )
    override val tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
    override val siteLinkEnabled: Option[SiteLinkEnabled] = scala
      .Option(impl.siteLinkEnabled())
      .map(value =>
        zio.aws.directconnect.model.primitives.SiteLinkEnabled(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceResponse
  ): zio.aws.directconnect.model.AssociateVirtualInterfaceResponse.ReadOnly =
    new Wrapper(impl)
}
