package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.{OwnerAccount, ConnectionId}
import scala.jdk.CollectionConverters._
final case class AllocateTransitVirtualInterfaceRequest(
    connectionId: ConnectionId,
    ownerAccount: OwnerAccount,
    newTransitVirtualInterfaceAllocation: zio.aws.directconnect.model.NewTransitVirtualInterfaceAllocation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceRequest = {
    import AllocateTransitVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .ownerAccount(OwnerAccount.unwrap(ownerAccount): java.lang.String)
      .newTransitVirtualInterfaceAllocation(
        newTransitVirtualInterfaceAllocation.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.AllocateTransitVirtualInterfaceRequest.ReadOnly =
    zio.aws.directconnect.model.AllocateTransitVirtualInterfaceRequest
      .wrap(buildAwsValue())
}
object AllocateTransitVirtualInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.AllocateTransitVirtualInterfaceRequest =
      zio.aws.directconnect.model.AllocateTransitVirtualInterfaceRequest(
        connectionId,
        ownerAccount,
        newTransitVirtualInterfaceAllocation.asEditable
      )
    def connectionId: ConnectionId
    def ownerAccount: OwnerAccount
    def newTransitVirtualInterfaceAllocation
        : zio.aws.directconnect.model.NewTransitVirtualInterfaceAllocation.ReadOnly
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
    def getOwnerAccount: ZIO[Any, Nothing, OwnerAccount] =
      ZIO.succeed(ownerAccount)
    def getNewTransitVirtualInterfaceAllocation: ZIO[
      Any,
      Nothing,
      zio.aws.directconnect.model.NewTransitVirtualInterfaceAllocation.ReadOnly
    ] = ZIO.succeed(newTransitVirtualInterfaceAllocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceRequest
  ) extends zio.aws.directconnect.model.AllocateTransitVirtualInterfaceRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
    override val ownerAccount: OwnerAccount =
      zio.aws.directconnect.model.primitives.OwnerAccount(impl.ownerAccount())
    override val newTransitVirtualInterfaceAllocation
        : zio.aws.directconnect.model.NewTransitVirtualInterfaceAllocation.ReadOnly =
      zio.aws.directconnect.model.NewTransitVirtualInterfaceAllocation
        .wrap(impl.newTransitVirtualInterfaceAllocation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceRequest
  ): zio.aws.directconnect.model.AllocateTransitVirtualInterfaceRequest.ReadOnly =
    new Wrapper(impl)
}
