package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.{OwnerAccount, ConnectionId}
import scala.jdk.CollectionConverters._
final case class AllocatePrivateVirtualInterfaceRequest(
    connectionId: ConnectionId,
    ownerAccount: OwnerAccount,
    newPrivateVirtualInterfaceAllocation: zio.aws.directconnect.model.NewPrivateVirtualInterfaceAllocation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest = {
    import AllocatePrivateVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .ownerAccount(OwnerAccount.unwrap(ownerAccount): java.lang.String)
      .newPrivateVirtualInterfaceAllocation(
        newPrivateVirtualInterfaceAllocation.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.AllocatePrivateVirtualInterfaceRequest.ReadOnly =
    zio.aws.directconnect.model.AllocatePrivateVirtualInterfaceRequest
      .wrap(buildAwsValue())
}
object AllocatePrivateVirtualInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.AllocatePrivateVirtualInterfaceRequest =
      zio.aws.directconnect.model.AllocatePrivateVirtualInterfaceRequest(
        connectionId,
        ownerAccount,
        newPrivateVirtualInterfaceAllocation.asEditable
      )
    def connectionId: ConnectionId
    def ownerAccount: OwnerAccount
    def newPrivateVirtualInterfaceAllocation
        : zio.aws.directconnect.model.NewPrivateVirtualInterfaceAllocation.ReadOnly
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
    def getOwnerAccount: ZIO[Any, Nothing, OwnerAccount] =
      ZIO.succeed(ownerAccount)
    def getNewPrivateVirtualInterfaceAllocation: ZIO[
      Any,
      Nothing,
      zio.aws.directconnect.model.NewPrivateVirtualInterfaceAllocation.ReadOnly
    ] = ZIO.succeed(newPrivateVirtualInterfaceAllocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest
  ) extends zio.aws.directconnect.model.AllocatePrivateVirtualInterfaceRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
    override val ownerAccount: OwnerAccount =
      zio.aws.directconnect.model.primitives.OwnerAccount(impl.ownerAccount())
    override val newPrivateVirtualInterfaceAllocation
        : zio.aws.directconnect.model.NewPrivateVirtualInterfaceAllocation.ReadOnly =
      zio.aws.directconnect.model.NewPrivateVirtualInterfaceAllocation
        .wrap(impl.newPrivateVirtualInterfaceAllocation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest
  ): zio.aws.directconnect.model.AllocatePrivateVirtualInterfaceRequest.ReadOnly =
    new Wrapper(impl)
}
