package zio.aws.directconnect.model
import scala.jdk.CollectionConverters._
sealed trait AddressFamily {
  def unwrap: software.amazon.awssdk.services.directconnect.model.AddressFamily
}
object AddressFamily {
  def wrap(
      value: software.amazon.awssdk.services.directconnect.model.AddressFamily
  ): zio.aws.directconnect.model.AddressFamily = value match {
    case software.amazon.awssdk.services.directconnect.model.AddressFamily.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.directconnect.model.AddressFamily.IPV4 =>
      val r = ipv4
      r
    case software.amazon.awssdk.services.directconnect.model.AddressFamily.IPV6 =>
      val r = ipv6
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.directconnect.model.AddressFamily {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.AddressFamily =
      software.amazon.awssdk.services.directconnect.model.AddressFamily.UNKNOWN_TO_SDK_VERSION
  }
  case object ipv4 extends zio.aws.directconnect.model.AddressFamily {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.AddressFamily =
      software.amazon.awssdk.services.directconnect.model.AddressFamily.IPV4
  }
  case object ipv6 extends zio.aws.directconnect.model.AddressFamily {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.AddressFamily =
      software.amazon.awssdk.services.directconnect.model.AddressFamily.IPV6
  }
}
