package zio.aws.directconnect.model
import scala.jdk.CollectionConverters._
sealed trait VirtualInterfaceState {
  def unwrap: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState
}
object VirtualInterfaceState {
  def wrap(
      value: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState
  ): zio.aws.directconnect.model.VirtualInterfaceState = value match {
    case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.CONFIRMING =>
      val r = confirming
      r
    case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.VERIFYING =>
      val r = verifying
      r
    case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.DOWN =>
      val r = down
      r
    case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.DELETED =>
      val r = deleted
      r
    case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.REJECTED =>
      val r = rejected
      r
    case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.UNKNOWN =>
      val r = unknown
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.directconnect.model.VirtualInterfaceState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState =
      software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.UNKNOWN_TO_SDK_VERSION
  }
  case object confirming
      extends zio.aws.directconnect.model.VirtualInterfaceState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState =
      software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.CONFIRMING
  }
  case object verifying
      extends zio.aws.directconnect.model.VirtualInterfaceState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState =
      software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.VERIFYING
  }
  case object pending
      extends zio.aws.directconnect.model.VirtualInterfaceState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState =
      software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.PENDING
  }
  case object available
      extends zio.aws.directconnect.model.VirtualInterfaceState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState =
      software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.AVAILABLE
  }
  case object down extends zio.aws.directconnect.model.VirtualInterfaceState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState =
      software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.DOWN
  }
  case object deleting
      extends zio.aws.directconnect.model.VirtualInterfaceState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState =
      software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.DELETING
  }
  case object deleted
      extends zio.aws.directconnect.model.VirtualInterfaceState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState =
      software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.DELETED
  }
  case object rejected
      extends zio.aws.directconnect.model.VirtualInterfaceState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState =
      software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.REJECTED
  }
  case object unknown
      extends zio.aws.directconnect.model.VirtualInterfaceState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState =
      software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.UNKNOWN
  }
}
