package zio.aws.directconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  EncryptionMode,
  Count,
  LagName,
  LagId
}
import scala.jdk.CollectionConverters._
final case class UpdateLagRequest(
    lagId: LagId,
    lagName: Option[LagName] = None,
    minimumLinks: Option[Count] = None,
    encryptionMode: Option[EncryptionMode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.UpdateLagRequest = {
    import UpdateLagRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.UpdateLagRequest
      .builder()
      .lagId(LagId.unwrap(lagId): java.lang.String)
      .optionallyWith(
        lagName.map(value => LagName.unwrap(value): java.lang.String)
      )(_.lagName)
      .optionallyWith(minimumLinks.map(value => Count.unwrap(value): Integer))(
        _.minimumLinks
      )
      .optionallyWith(
        encryptionMode.map(value =>
          EncryptionMode.unwrap(value): java.lang.String
        )
      )(_.encryptionMode)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.UpdateLagRequest.ReadOnly =
    zio.aws.directconnect.model.UpdateLagRequest.wrap(buildAwsValue())
}
object UpdateLagRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.UpdateLagRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.UpdateLagRequest =
      zio.aws.directconnect.model.UpdateLagRequest(
        lagId,
        lagName.map(value => value),
        minimumLinks.map(value => value),
        encryptionMode.map(value => value)
      )
    def lagId: LagId
    def lagName: Option[LagName]
    def minimumLinks: Option[Count]
    def encryptionMode: Option[EncryptionMode]
    def getLagId: ZIO[Any, Nothing, LagId] = ZIO.succeed(lagId)
    def getLagName: ZIO[Any, AwsError, LagName] =
      AwsError.unwrapOptionField("lagName", lagName)
    def getMinimumLinks: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("minimumLinks", minimumLinks)
    def getEncryptionMode: ZIO[Any, AwsError, EncryptionMode] =
      AwsError.unwrapOptionField("encryptionMode", encryptionMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.UpdateLagRequest
  ) extends zio.aws.directconnect.model.UpdateLagRequest.ReadOnly {
    override val lagId: LagId =
      zio.aws.directconnect.model.primitives.LagId(impl.lagId())
    override val lagName: Option[LagName] = scala
      .Option(impl.lagName())
      .map(value => zio.aws.directconnect.model.primitives.LagName(value))
    override val minimumLinks: Option[Count] = scala
      .Option(impl.minimumLinks())
      .map(value => zio.aws.directconnect.model.primitives.Count(value))
    override val encryptionMode: Option[EncryptionMode] = scala
      .Option(impl.encryptionMode())
      .map(value =>
        zio.aws.directconnect.model.primitives.EncryptionMode(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.UpdateLagRequest
  ): zio.aws.directconnect.model.UpdateLagRequest.ReadOnly = new Wrapper(impl)
}
