package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.{
  DirectConnectGatewayName,
  DirectConnectGatewayId
}
import scala.jdk.CollectionConverters._
final case class UpdateDirectConnectGatewayRequest(
    directConnectGatewayId: DirectConnectGatewayId,
    newDirectConnectGatewayName: DirectConnectGatewayName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayRequest = {
    import UpdateDirectConnectGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayRequest
      .builder()
      .directConnectGatewayId(
        DirectConnectGatewayId.unwrap(directConnectGatewayId): java.lang.String
      )
      .newDirectConnectGatewayName(
        DirectConnectGatewayName.unwrap(
          newDirectConnectGatewayName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.UpdateDirectConnectGatewayRequest.ReadOnly =
    zio.aws.directconnect.model.UpdateDirectConnectGatewayRequest
      .wrap(buildAwsValue())
}
object UpdateDirectConnectGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.UpdateDirectConnectGatewayRequest =
      zio.aws.directconnect.model.UpdateDirectConnectGatewayRequest(
        directConnectGatewayId,
        newDirectConnectGatewayName
      )
    def directConnectGatewayId: DirectConnectGatewayId
    def newDirectConnectGatewayName: DirectConnectGatewayName
    def getDirectConnectGatewayId: ZIO[Any, Nothing, DirectConnectGatewayId] =
      ZIO.succeed(directConnectGatewayId)
    def getNewDirectConnectGatewayName
        : ZIO[Any, Nothing, DirectConnectGatewayName] =
      ZIO.succeed(newDirectConnectGatewayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayRequest
  ) extends zio.aws.directconnect.model.UpdateDirectConnectGatewayRequest.ReadOnly {
    override val directConnectGatewayId: DirectConnectGatewayId =
      zio.aws.directconnect.model.primitives
        .DirectConnectGatewayId(impl.directConnectGatewayId())
    override val newDirectConnectGatewayName: DirectConnectGatewayName =
      zio.aws.directconnect.model.primitives
        .DirectConnectGatewayName(impl.newDirectConnectGatewayName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayRequest
  ): zio.aws.directconnect.model.UpdateDirectConnectGatewayRequest.ReadOnly =
    new Wrapper(impl)
}
