package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  RouterTypeIdentifier,
  Vendor,
  XsltTemplateNameForMacSec,
  Platform,
  Software,
  XsltTemplateName
}
import scala.jdk.CollectionConverters._
final case class RouterType(
    vendor: Option[Vendor] = None,
    platform: Option[Platform] = None,
    software: Option[Software] = None,
    xsltTemplateName: Option[XsltTemplateName] = None,
    xsltTemplateNameForMacSec: Option[XsltTemplateNameForMacSec] = None,
    routerTypeIdentifier: Option[RouterTypeIdentifier] = None
) {
  def buildAwsValue()
      : _root_.software.amazon.awssdk.services.directconnect.model.RouterType = {
    import RouterType.zioAwsBuilderHelper.BuilderOps
    _root_.software.amazon.awssdk.services.directconnect.model.RouterType
      .builder()
      .optionallyWith(
        vendor.map(value => Vendor.unwrap(value): java.lang.String)
      )(_.vendor)
      .optionallyWith(
        platform.map(value => Platform.unwrap(value): java.lang.String)
      )(_.platform)
      .optionallyWith(
        software.map(value => Software.unwrap(value): java.lang.String)
      )(_.software)
      .optionallyWith(
        xsltTemplateName.map(value =>
          XsltTemplateName.unwrap(value): java.lang.String
        )
      )(_.xsltTemplateName)
      .optionallyWith(
        xsltTemplateNameForMacSec.map(value =>
          XsltTemplateNameForMacSec.unwrap(value): java.lang.String
        )
      )(_.xsltTemplateNameForMacSec)
      .optionallyWith(
        routerTypeIdentifier.map(value =>
          RouterTypeIdentifier.unwrap(value): java.lang.String
        )
      )(_.routerTypeIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.RouterType.ReadOnly =
    zio.aws.directconnect.model.RouterType.wrap(buildAwsValue())
}
object RouterType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    _root_.software.amazon.awssdk.services.directconnect.model.RouterType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.RouterType =
      zio.aws.directconnect.model.RouterType(
        vendor.map(value => value),
        platform.map(value => value),
        software.map(value => value),
        xsltTemplateName.map(value => value),
        xsltTemplateNameForMacSec.map(value => value),
        routerTypeIdentifier.map(value => value)
      )
    def vendor: Option[Vendor]
    def platform: Option[Platform]
    def software: Option[Software]
    def xsltTemplateName: Option[XsltTemplateName]
    def xsltTemplateNameForMacSec: Option[XsltTemplateNameForMacSec]
    def routerTypeIdentifier: Option[RouterTypeIdentifier]
    def getVendor: ZIO[Any, AwsError, Vendor] =
      AwsError.unwrapOptionField("vendor", vendor)
    def getPlatform: ZIO[Any, AwsError, Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getSoftware: ZIO[Any, AwsError, Software] =
      AwsError.unwrapOptionField("software", software)
    def getXsltTemplateName: ZIO[Any, AwsError, XsltTemplateName] =
      AwsError.unwrapOptionField("xsltTemplateName", xsltTemplateName)
    def getXsltTemplateNameForMacSec
        : ZIO[Any, AwsError, XsltTemplateNameForMacSec] = AwsError
      .unwrapOptionField("xsltTemplateNameForMacSec", xsltTemplateNameForMacSec)
    def getRouterTypeIdentifier: ZIO[Any, AwsError, RouterTypeIdentifier] =
      AwsError.unwrapOptionField("routerTypeIdentifier", routerTypeIdentifier)
  }
  private final class Wrapper(
      impl: _root_.software.amazon.awssdk.services.directconnect.model.RouterType
  ) extends zio.aws.directconnect.model.RouterType.ReadOnly {
    override val vendor: Option[Vendor] = scala
      .Option(impl.vendor())
      .map(value => zio.aws.directconnect.model.primitives.Vendor(value))
    override val platform: Option[Platform] = scala
      .Option(impl.platform())
      .map(value => zio.aws.directconnect.model.primitives.Platform(value))
    override val software: Option[Software] = scala
      .Option(impl.software())
      .map(value => zio.aws.directconnect.model.primitives.Software(value))
    override val xsltTemplateName: Option[XsltTemplateName] = scala
      .Option(impl.xsltTemplateName())
      .map(value =>
        zio.aws.directconnect.model.primitives.XsltTemplateName(value)
      )
    override val xsltTemplateNameForMacSec: Option[XsltTemplateNameForMacSec] =
      scala
        .Option(impl.xsltTemplateNameForMacSec())
        .map(value =>
          zio.aws.directconnect.model.primitives
            .XsltTemplateNameForMacSec(value)
        )
    override val routerTypeIdentifier: Option[RouterTypeIdentifier] = scala
      .Option(impl.routerTypeIdentifier())
      .map(value =>
        zio.aws.directconnect.model.primitives.RouterTypeIdentifier(value)
      )
  }
  def wrap(
      impl: _root_.software.amazon.awssdk.services.directconnect.model.RouterType
  ): zio.aws.directconnect.model.RouterType.ReadOnly = new Wrapper(impl)
}
