package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.CIDR
import scala.jdk.CollectionConverters._
final case class RouteFilterPrefix(cidr: Option[CIDR] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix = {
    import RouteFilterPrefix.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix
      .builder()
      .optionallyWith(cidr.map(value => CIDR.unwrap(value): java.lang.String))(
        _.cidr
      )
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly =
    zio.aws.directconnect.model.RouteFilterPrefix.wrap(buildAwsValue())
}
object RouteFilterPrefix {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.RouteFilterPrefix =
      zio.aws.directconnect.model.RouteFilterPrefix(cidr.map(value => value))
    def cidr: Option[CIDR]
    def getCidr: ZIO[Any, AwsError, CIDR] =
      AwsError.unwrapOptionField("cidr", cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix
  ) extends zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly {
    override val cidr: Option[CIDR] = scala
      .Option(impl.cidr())
      .map(value => zio.aws.directconnect.model.primitives.CIDR(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix
  ): zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly = new Wrapper(impl)
}
