package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class ResourceTag(
    resourceArn: Option[ResourceArn] = None,
    tags: Option[Iterable[zio.aws.directconnect.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.ResourceTag = {
    import ResourceTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.ResourceTag
      .builder()
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.ResourceTag.ReadOnly =
    zio.aws.directconnect.model.ResourceTag.wrap(buildAwsValue())
}
object ResourceTag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.ResourceTag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.ResourceTag =
      zio.aws.directconnect.model.ResourceTag(
        resourceArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceArn: Option[ResourceArn]
    def tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.ResourceTag
  ) extends zio.aws.directconnect.model.ResourceTag.ReadOnly {
    override val resourceArn: Option[ResourceArn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.directconnect.model.primitives.ResourceArn(value))
    override val tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.ResourceTag
  ): zio.aws.directconnect.model.ResourceTag.ReadOnly = new Wrapper(impl)
}
