package zio.aws.directconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  FailureTestHistoryStatus,
  PaginationToken,
  MaxResultSetSize,
  VirtualInterfaceId,
  TestId,
  BGPPeerId
}
import scala.jdk.CollectionConverters._
final case class ListVirtualInterfaceTestHistoryRequest(
    testId: Option[TestId] = None,
    virtualInterfaceId: Option[VirtualInterfaceId] = None,
    bgpPeers: Option[Iterable[BGPPeerId]] = None,
    status: Option[FailureTestHistoryStatus] = None,
    maxResults: Option[MaxResultSetSize] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest = {
    import ListVirtualInterfaceTestHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest
      .builder()
      .optionallyWith(
        testId.map(value => TestId.unwrap(value): java.lang.String)
      )(_.testId)
      .optionallyWith(
        virtualInterfaceId.map(value =>
          VirtualInterfaceId.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceId)
      .optionallyWith(
        bgpPeers.map(value =>
          value.map { item =>
            BGPPeerId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.bgpPeers)
      .optionallyWith(
        status.map(value =>
          FailureTestHistoryStatus.unwrap(value): java.lang.String
        )
      )(_.status)
      .optionallyWith(
        maxResults.map(value => MaxResultSetSize.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryRequest.ReadOnly =
    zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryRequest
      .wrap(buildAwsValue())
}
object ListVirtualInterfaceTestHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryRequest =
      zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryRequest(
        testId.map(value => value),
        virtualInterfaceId.map(value => value),
        bgpPeers.map(value => value),
        status.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def testId: Option[TestId]
    def virtualInterfaceId: Option[VirtualInterfaceId]
    def bgpPeers: Option[List[BGPPeerId]]
    def status: Option[FailureTestHistoryStatus]
    def maxResults: Option[MaxResultSetSize]
    def nextToken: Option[PaginationToken]
    def getTestId: ZIO[Any, AwsError, TestId] =
      AwsError.unwrapOptionField("testId", testId)
    def getVirtualInterfaceId: ZIO[Any, AwsError, VirtualInterfaceId] =
      AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceId)
    def getBgpPeers: ZIO[Any, AwsError, List[BGPPeerId]] =
      AwsError.unwrapOptionField("bgpPeers", bgpPeers)
    def getStatus: ZIO[Any, AwsError, FailureTestHistoryStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMaxResults: ZIO[Any, AwsError, MaxResultSetSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest
  ) extends zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryRequest.ReadOnly {
    override val testId: Option[TestId] = scala
      .Option(impl.testId())
      .map(value => zio.aws.directconnect.model.primitives.TestId(value))
    override val virtualInterfaceId: Option[VirtualInterfaceId] = scala
      .Option(impl.virtualInterfaceId())
      .map(value =>
        zio.aws.directconnect.model.primitives.VirtualInterfaceId(value)
      )
    override val bgpPeers: Option[List[BGPPeerId]] = scala
      .Option(impl.bgpPeers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.primitives.BGPPeerId(item)
        }.toList
      )
    override val status: Option[FailureTestHistoryStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.directconnect.model.primitives.FailureTestHistoryStatus(value)
      )
    override val maxResults: Option[MaxResultSetSize] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.directconnect.model.primitives.MaxResultSetSize(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.directconnect.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest
  ): zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
