package zio.aws.directconnect.model
import scala.jdk.CollectionConverters._
sealed trait LagState {
  def unwrap: software.amazon.awssdk.services.directconnect.model.LagState
}
object LagState {
  def wrap(
      value: software.amazon.awssdk.services.directconnect.model.LagState
  ): zio.aws.directconnect.model.LagState = value match {
    case software.amazon.awssdk.services.directconnect.model.LagState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.directconnect.model.LagState.REQUESTED =>
      val r = requested
      r
    case software.amazon.awssdk.services.directconnect.model.LagState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.directconnect.model.LagState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.directconnect.model.LagState.DOWN =>
      val r = down
      r
    case software.amazon.awssdk.services.directconnect.model.LagState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.directconnect.model.LagState.DELETED =>
      val r = deleted
      r
    case software.amazon.awssdk.services.directconnect.model.LagState.UNKNOWN =>
      val r = unknown
      r
  }
  case object unknownToSdkVersion extends zio.aws.directconnect.model.LagState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.LagState =
      software.amazon.awssdk.services.directconnect.model.LagState.UNKNOWN_TO_SDK_VERSION
  }
  case object requested extends zio.aws.directconnect.model.LagState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.LagState =
      software.amazon.awssdk.services.directconnect.model.LagState.REQUESTED
  }
  case object pending extends zio.aws.directconnect.model.LagState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.LagState =
      software.amazon.awssdk.services.directconnect.model.LagState.PENDING
  }
  case object available extends zio.aws.directconnect.model.LagState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.LagState =
      software.amazon.awssdk.services.directconnect.model.LagState.AVAILABLE
  }
  case object down extends zio.aws.directconnect.model.LagState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.LagState =
      software.amazon.awssdk.services.directconnect.model.LagState.DOWN
  }
  case object deleting extends zio.aws.directconnect.model.LagState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.LagState =
      software.amazon.awssdk.services.directconnect.model.LagState.DELETING
  }
  case object deleted extends zio.aws.directconnect.model.LagState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.LagState =
      software.amazon.awssdk.services.directconnect.model.LagState.DELETED
  }
  case object unknown extends zio.aws.directconnect.model.LagState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.LagState =
      software.amazon.awssdk.services.directconnect.model.LagState.UNKNOWN
  }
}
