package zio.aws.directconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  OwnerAccount,
  EncryptionMode,
  ProviderName,
  LagName,
  Count,
  BooleanFlag,
  AwsDeviceV2,
  MacSecCapable,
  Bandwidth,
  Region,
  AwsLogicalDeviceId,
  AwsDevice,
  JumboFrameCapable,
  LagId,
  LocationCode
}
import scala.jdk.CollectionConverters._
final case class Lag(
    connectionsBandwidth: Option[Bandwidth] = None,
    numberOfConnections: Option[Count] = None,
    lagId: Option[LagId] = None,
    ownerAccount: Option[OwnerAccount] = None,
    lagName: Option[LagName] = None,
    lagState: Option[zio.aws.directconnect.model.LagState] = None,
    location: Option[LocationCode] = None,
    region: Option[Region] = None,
    minimumLinks: Option[Count] = None,
    awsDevice: Option[AwsDevice] = None,
    awsDeviceV2: Option[AwsDeviceV2] = None,
    awsLogicalDeviceId: Option[AwsLogicalDeviceId] = None,
    connections: Option[Iterable[zio.aws.directconnect.model.Connection]] =
      None,
    allowsHostedConnections: Option[BooleanFlag] = None,
    jumboFrameCapable: Option[JumboFrameCapable] = None,
    hasLogicalRedundancy: Option[
      zio.aws.directconnect.model.HasLogicalRedundancy
    ] = None,
    tags: Option[Iterable[zio.aws.directconnect.model.Tag]] = None,
    providerName: Option[ProviderName] = None,
    macSecCapable: Option[MacSecCapable] = None,
    encryptionMode: Option[EncryptionMode] = None,
    macSecKeys: Option[Iterable[zio.aws.directconnect.model.MacSecKey]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.Lag = {
    import Lag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.Lag
      .builder()
      .optionallyWith(
        connectionsBandwidth.map(value =>
          Bandwidth.unwrap(value): java.lang.String
        )
      )(_.connectionsBandwidth)
      .optionallyWith(
        numberOfConnections.map(value => Count.unwrap(value): Integer)
      )(_.numberOfConnections)
      .optionallyWith(
        lagId.map(value => LagId.unwrap(value): java.lang.String)
      )(_.lagId)
      .optionallyWith(
        ownerAccount.map(value => OwnerAccount.unwrap(value): java.lang.String)
      )(_.ownerAccount)
      .optionallyWith(
        lagName.map(value => LagName.unwrap(value): java.lang.String)
      )(_.lagName)
      .optionallyWith(lagState.map(value => value.unwrap))(_.lagState)
      .optionallyWith(
        location.map(value => LocationCode.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(minimumLinks.map(value => Count.unwrap(value): Integer))(
        _.minimumLinks
      )
      .optionallyWith(
        awsDevice.map(value => AwsDevice.unwrap(value): java.lang.String)
      )(_.awsDevice)
      .optionallyWith(
        awsDeviceV2.map(value => AwsDeviceV2.unwrap(value): java.lang.String)
      )(_.awsDeviceV2)
      .optionallyWith(
        awsLogicalDeviceId.map(value =>
          AwsLogicalDeviceId.unwrap(value): java.lang.String
        )
      )(_.awsLogicalDeviceId)
      .optionallyWith(
        connections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connections)
      .optionallyWith(
        allowsHostedConnections.map(value =>
          BooleanFlag.unwrap(value): java.lang.Boolean
        )
      )(_.allowsHostedConnections)
      .optionallyWith(
        jumboFrameCapable.map(value =>
          JumboFrameCapable.unwrap(value): java.lang.Boolean
        )
      )(_.jumboFrameCapable)
      .optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(
        _.hasLogicalRedundancy
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        providerName.map(value => ProviderName.unwrap(value): java.lang.String)
      )(_.providerName)
      .optionallyWith(
        macSecCapable.map(value =>
          MacSecCapable.unwrap(value): java.lang.Boolean
        )
      )(_.macSecCapable)
      .optionallyWith(
        encryptionMode.map(value =>
          EncryptionMode.unwrap(value): java.lang.String
        )
      )(_.encryptionMode)
      .optionallyWith(
        macSecKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.macSecKeys)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.Lag.ReadOnly =
    zio.aws.directconnect.model.Lag.wrap(buildAwsValue())
}
object Lag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.directconnect.model.Lag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.Lag =
      zio.aws.directconnect.model.Lag(
        connectionsBandwidth.map(value => value),
        numberOfConnections.map(value => value),
        lagId.map(value => value),
        ownerAccount.map(value => value),
        lagName.map(value => value),
        lagState.map(value => value),
        location.map(value => value),
        region.map(value => value),
        minimumLinks.map(value => value),
        awsDevice.map(value => value),
        awsDeviceV2.map(value => value),
        awsLogicalDeviceId.map(value => value),
        connections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        allowsHostedConnections.map(value => value),
        jumboFrameCapable.map(value => value),
        hasLogicalRedundancy.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        providerName.map(value => value),
        macSecCapable.map(value => value),
        encryptionMode.map(value => value),
        macSecKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def connectionsBandwidth: Option[Bandwidth]
    def numberOfConnections: Option[Count]
    def lagId: Option[LagId]
    def ownerAccount: Option[OwnerAccount]
    def lagName: Option[LagName]
    def lagState: Option[zio.aws.directconnect.model.LagState]
    def location: Option[LocationCode]
    def region: Option[Region]
    def minimumLinks: Option[Count]
    def awsDevice: Option[AwsDevice]
    def awsDeviceV2: Option[AwsDeviceV2]
    def awsLogicalDeviceId: Option[AwsLogicalDeviceId]
    def connections
        : Option[List[zio.aws.directconnect.model.Connection.ReadOnly]]
    def allowsHostedConnections: Option[BooleanFlag]
    def jumboFrameCapable: Option[JumboFrameCapable]
    def hasLogicalRedundancy
        : Option[zio.aws.directconnect.model.HasLogicalRedundancy]
    def tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def providerName: Option[ProviderName]
    def macSecCapable: Option[MacSecCapable]
    def encryptionMode: Option[EncryptionMode]
    def macSecKeys: Option[List[zio.aws.directconnect.model.MacSecKey.ReadOnly]]
    def getConnectionsBandwidth: ZIO[Any, AwsError, Bandwidth] =
      AwsError.unwrapOptionField("connectionsBandwidth", connectionsBandwidth)
    def getNumberOfConnections: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("numberOfConnections", numberOfConnections)
    def getLagId: ZIO[Any, AwsError, LagId] =
      AwsError.unwrapOptionField("lagId", lagId)
    def getOwnerAccount: ZIO[Any, AwsError, OwnerAccount] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getLagName: ZIO[Any, AwsError, LagName] =
      AwsError.unwrapOptionField("lagName", lagName)
    def getLagState: ZIO[Any, AwsError, zio.aws.directconnect.model.LagState] =
      AwsError.unwrapOptionField("lagState", lagState)
    def getLocation: ZIO[Any, AwsError, LocationCode] =
      AwsError.unwrapOptionField("location", location)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getMinimumLinks: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("minimumLinks", minimumLinks)
    def getAwsDevice: ZIO[Any, AwsError, AwsDevice] =
      AwsError.unwrapOptionField("awsDevice", awsDevice)
    def getAwsDeviceV2: ZIO[Any, AwsError, AwsDeviceV2] =
      AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2)
    def getAwsLogicalDeviceId: ZIO[Any, AwsError, AwsLogicalDeviceId] =
      AwsError.unwrapOptionField("awsLogicalDeviceId", awsLogicalDeviceId)
    def getConnections: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.Connection.ReadOnly
    ]] = AwsError.unwrapOptionField("connections", connections)
    def getAllowsHostedConnections: ZIO[Any, AwsError, BooleanFlag] = AwsError
      .unwrapOptionField("allowsHostedConnections", allowsHostedConnections)
    def getJumboFrameCapable: ZIO[Any, AwsError, JumboFrameCapable] =
      AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapable)
    def getHasLogicalRedundancy
        : ZIO[Any, AwsError, zio.aws.directconnect.model.HasLogicalRedundancy] =
      AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancy)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getProviderName: ZIO[Any, AwsError, ProviderName] =
      AwsError.unwrapOptionField("providerName", providerName)
    def getMacSecCapable: ZIO[Any, AwsError, MacSecCapable] =
      AwsError.unwrapOptionField("macSecCapable", macSecCapable)
    def getEncryptionMode: ZIO[Any, AwsError, EncryptionMode] =
      AwsError.unwrapOptionField("encryptionMode", encryptionMode)
    def getMacSecKeys: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.MacSecKey.ReadOnly
    ]] = AwsError.unwrapOptionField("macSecKeys", macSecKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.Lag
  ) extends zio.aws.directconnect.model.Lag.ReadOnly {
    override val connectionsBandwidth: Option[Bandwidth] = scala
      .Option(impl.connectionsBandwidth())
      .map(value => zio.aws.directconnect.model.primitives.Bandwidth(value))
    override val numberOfConnections: Option[Count] = scala
      .Option(impl.numberOfConnections())
      .map(value => zio.aws.directconnect.model.primitives.Count(value))
    override val lagId: Option[LagId] = scala
      .Option(impl.lagId())
      .map(value => zio.aws.directconnect.model.primitives.LagId(value))
    override val ownerAccount: Option[OwnerAccount] = scala
      .Option(impl.ownerAccount())
      .map(value => zio.aws.directconnect.model.primitives.OwnerAccount(value))
    override val lagName: Option[LagName] = scala
      .Option(impl.lagName())
      .map(value => zio.aws.directconnect.model.primitives.LagName(value))
    override val lagState: Option[zio.aws.directconnect.model.LagState] = scala
      .Option(impl.lagState())
      .map(value => zio.aws.directconnect.model.LagState.wrap(value))
    override val location: Option[LocationCode] = scala
      .Option(impl.location())
      .map(value => zio.aws.directconnect.model.primitives.LocationCode(value))
    override val region: Option[Region] = scala
      .Option(impl.region())
      .map(value => zio.aws.directconnect.model.primitives.Region(value))
    override val minimumLinks: Option[Count] = scala
      .Option(impl.minimumLinks())
      .map(value => zio.aws.directconnect.model.primitives.Count(value))
    override val awsDevice: Option[AwsDevice] = scala
      .Option(impl.awsDevice())
      .map(value => zio.aws.directconnect.model.primitives.AwsDevice(value))
    override val awsDeviceV2: Option[AwsDeviceV2] = scala
      .Option(impl.awsDeviceV2())
      .map(value => zio.aws.directconnect.model.primitives.AwsDeviceV2(value))
    override val awsLogicalDeviceId: Option[AwsLogicalDeviceId] = scala
      .Option(impl.awsLogicalDeviceId())
      .map(value =>
        zio.aws.directconnect.model.primitives.AwsLogicalDeviceId(value)
      )
    override val connections
        : Option[List[zio.aws.directconnect.model.Connection.ReadOnly]] = scala
      .Option(impl.connections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.Connection.wrap(item)
        }.toList
      )
    override val allowsHostedConnections: Option[BooleanFlag] = scala
      .Option(impl.allowsHostedConnections())
      .map(value => zio.aws.directconnect.model.primitives.BooleanFlag(value))
    override val jumboFrameCapable: Option[JumboFrameCapable] = scala
      .Option(impl.jumboFrameCapable())
      .map(value =>
        zio.aws.directconnect.model.primitives.JumboFrameCapable(value)
      )
    override val hasLogicalRedundancy
        : Option[zio.aws.directconnect.model.HasLogicalRedundancy] = scala
      .Option(impl.hasLogicalRedundancy())
      .map(value =>
        zio.aws.directconnect.model.HasLogicalRedundancy.wrap(value)
      )
    override val tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
    override val providerName: Option[ProviderName] = scala
      .Option(impl.providerName())
      .map(value => zio.aws.directconnect.model.primitives.ProviderName(value))
    override val macSecCapable: Option[MacSecCapable] = scala
      .Option(impl.macSecCapable())
      .map(value => zio.aws.directconnect.model.primitives.MacSecCapable(value))
    override val encryptionMode: Option[EncryptionMode] = scala
      .Option(impl.encryptionMode())
      .map(value =>
        zio.aws.directconnect.model.primitives.EncryptionMode(value)
      )
    override val macSecKeys
        : Option[List[zio.aws.directconnect.model.MacSecKey.ReadOnly]] = scala
      .Option(impl.macSecKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.MacSecKey.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.Lag
  ): zio.aws.directconnect.model.Lag.ReadOnly = new Wrapper(impl)
}
