package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.directconnect.model.primitives.{
  ProviderName,
  AwsDeviceV2,
  Bandwidth,
  Region,
  AwsLogicalDeviceId,
  AwsDevice,
  InterconnectId,
  JumboFrameCapable,
  InterconnectName,
  LagId,
  LocationCode,
  LoaIssueTime
}
import scala.jdk.CollectionConverters._
final case class Interconnect(
    interconnectId: Option[InterconnectId] = None,
    interconnectName: Option[InterconnectName] = None,
    interconnectState: Option[zio.aws.directconnect.model.InterconnectState] =
      None,
    region: Option[Region] = None,
    location: Option[LocationCode] = None,
    bandwidth: Option[Bandwidth] = None,
    loaIssueTime: Option[LoaIssueTime] = None,
    lagId: Option[LagId] = None,
    awsDevice: Option[AwsDevice] = None,
    jumboFrameCapable: Option[JumboFrameCapable] = None,
    awsDeviceV2: Option[AwsDeviceV2] = None,
    awsLogicalDeviceId: Option[AwsLogicalDeviceId] = None,
    hasLogicalRedundancy: Option[
      zio.aws.directconnect.model.HasLogicalRedundancy
    ] = None,
    tags: Option[Iterable[zio.aws.directconnect.model.Tag]] = None,
    providerName: Option[ProviderName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.Interconnect = {
    import Interconnect.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.Interconnect
      .builder()
      .optionallyWith(
        interconnectId.map(value =>
          InterconnectId.unwrap(value): java.lang.String
        )
      )(_.interconnectId)
      .optionallyWith(
        interconnectName.map(value =>
          InterconnectName.unwrap(value): java.lang.String
        )
      )(_.interconnectName)
      .optionallyWith(interconnectState.map(value => value.unwrap))(
        _.interconnectState
      )
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        location.map(value => LocationCode.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(
        bandwidth.map(value => Bandwidth.unwrap(value): java.lang.String)
      )(_.bandwidth)
      .optionallyWith(
        loaIssueTime.map(value => LoaIssueTime.unwrap(value): Instant)
      )(_.loaIssueTime)
      .optionallyWith(
        lagId.map(value => LagId.unwrap(value): java.lang.String)
      )(_.lagId)
      .optionallyWith(
        awsDevice.map(value => AwsDevice.unwrap(value): java.lang.String)
      )(_.awsDevice)
      .optionallyWith(
        jumboFrameCapable.map(value =>
          JumboFrameCapable.unwrap(value): java.lang.Boolean
        )
      )(_.jumboFrameCapable)
      .optionallyWith(
        awsDeviceV2.map(value => AwsDeviceV2.unwrap(value): java.lang.String)
      )(_.awsDeviceV2)
      .optionallyWith(
        awsLogicalDeviceId.map(value =>
          AwsLogicalDeviceId.unwrap(value): java.lang.String
        )
      )(_.awsLogicalDeviceId)
      .optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(
        _.hasLogicalRedundancy
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        providerName.map(value => ProviderName.unwrap(value): java.lang.String)
      )(_.providerName)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.Interconnect.ReadOnly =
    zio.aws.directconnect.model.Interconnect.wrap(buildAwsValue())
}
object Interconnect {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.Interconnect
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.Interconnect =
      zio.aws.directconnect.model.Interconnect(
        interconnectId.map(value => value),
        interconnectName.map(value => value),
        interconnectState.map(value => value),
        region.map(value => value),
        location.map(value => value),
        bandwidth.map(value => value),
        loaIssueTime.map(value => value),
        lagId.map(value => value),
        awsDevice.map(value => value),
        jumboFrameCapable.map(value => value),
        awsDeviceV2.map(value => value),
        awsLogicalDeviceId.map(value => value),
        hasLogicalRedundancy.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        providerName.map(value => value)
      )
    def interconnectId: Option[InterconnectId]
    def interconnectName: Option[InterconnectName]
    def interconnectState: Option[zio.aws.directconnect.model.InterconnectState]
    def region: Option[Region]
    def location: Option[LocationCode]
    def bandwidth: Option[Bandwidth]
    def loaIssueTime: Option[LoaIssueTime]
    def lagId: Option[LagId]
    def awsDevice: Option[AwsDevice]
    def jumboFrameCapable: Option[JumboFrameCapable]
    def awsDeviceV2: Option[AwsDeviceV2]
    def awsLogicalDeviceId: Option[AwsLogicalDeviceId]
    def hasLogicalRedundancy
        : Option[zio.aws.directconnect.model.HasLogicalRedundancy]
    def tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def providerName: Option[ProviderName]
    def getInterconnectId: ZIO[Any, AwsError, InterconnectId] =
      AwsError.unwrapOptionField("interconnectId", interconnectId)
    def getInterconnectName: ZIO[Any, AwsError, InterconnectName] =
      AwsError.unwrapOptionField("interconnectName", interconnectName)
    def getInterconnectState
        : ZIO[Any, AwsError, zio.aws.directconnect.model.InterconnectState] =
      AwsError.unwrapOptionField("interconnectState", interconnectState)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getLocation: ZIO[Any, AwsError, LocationCode] =
      AwsError.unwrapOptionField("location", location)
    def getBandwidth: ZIO[Any, AwsError, Bandwidth] =
      AwsError.unwrapOptionField("bandwidth", bandwidth)
    def getLoaIssueTime: ZIO[Any, AwsError, LoaIssueTime] =
      AwsError.unwrapOptionField("loaIssueTime", loaIssueTime)
    def getLagId: ZIO[Any, AwsError, LagId] =
      AwsError.unwrapOptionField("lagId", lagId)
    def getAwsDevice: ZIO[Any, AwsError, AwsDevice] =
      AwsError.unwrapOptionField("awsDevice", awsDevice)
    def getJumboFrameCapable: ZIO[Any, AwsError, JumboFrameCapable] =
      AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapable)
    def getAwsDeviceV2: ZIO[Any, AwsError, AwsDeviceV2] =
      AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2)
    def getAwsLogicalDeviceId: ZIO[Any, AwsError, AwsLogicalDeviceId] =
      AwsError.unwrapOptionField("awsLogicalDeviceId", awsLogicalDeviceId)
    def getHasLogicalRedundancy
        : ZIO[Any, AwsError, zio.aws.directconnect.model.HasLogicalRedundancy] =
      AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancy)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getProviderName: ZIO[Any, AwsError, ProviderName] =
      AwsError.unwrapOptionField("providerName", providerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.Interconnect
  ) extends zio.aws.directconnect.model.Interconnect.ReadOnly {
    override val interconnectId: Option[InterconnectId] = scala
      .Option(impl.interconnectId())
      .map(value =>
        zio.aws.directconnect.model.primitives.InterconnectId(value)
      )
    override val interconnectName: Option[InterconnectName] = scala
      .Option(impl.interconnectName())
      .map(value =>
        zio.aws.directconnect.model.primitives.InterconnectName(value)
      )
    override val interconnectState
        : Option[zio.aws.directconnect.model.InterconnectState] = scala
      .Option(impl.interconnectState())
      .map(value => zio.aws.directconnect.model.InterconnectState.wrap(value))
    override val region: Option[Region] = scala
      .Option(impl.region())
      .map(value => zio.aws.directconnect.model.primitives.Region(value))
    override val location: Option[LocationCode] = scala
      .Option(impl.location())
      .map(value => zio.aws.directconnect.model.primitives.LocationCode(value))
    override val bandwidth: Option[Bandwidth] = scala
      .Option(impl.bandwidth())
      .map(value => zio.aws.directconnect.model.primitives.Bandwidth(value))
    override val loaIssueTime: Option[LoaIssueTime] = scala
      .Option(impl.loaIssueTime())
      .map(value => zio.aws.directconnect.model.primitives.LoaIssueTime(value))
    override val lagId: Option[LagId] = scala
      .Option(impl.lagId())
      .map(value => zio.aws.directconnect.model.primitives.LagId(value))
    override val awsDevice: Option[AwsDevice] = scala
      .Option(impl.awsDevice())
      .map(value => zio.aws.directconnect.model.primitives.AwsDevice(value))
    override val jumboFrameCapable: Option[JumboFrameCapable] = scala
      .Option(impl.jumboFrameCapable())
      .map(value =>
        zio.aws.directconnect.model.primitives.JumboFrameCapable(value)
      )
    override val awsDeviceV2: Option[AwsDeviceV2] = scala
      .Option(impl.awsDeviceV2())
      .map(value => zio.aws.directconnect.model.primitives.AwsDeviceV2(value))
    override val awsLogicalDeviceId: Option[AwsLogicalDeviceId] = scala
      .Option(impl.awsLogicalDeviceId())
      .map(value =>
        zio.aws.directconnect.model.primitives.AwsLogicalDeviceId(value)
      )
    override val hasLogicalRedundancy
        : Option[zio.aws.directconnect.model.HasLogicalRedundancy] = scala
      .Option(impl.hasLogicalRedundancy())
      .map(value =>
        zio.aws.directconnect.model.HasLogicalRedundancy.wrap(value)
      )
    override val tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
    override val providerName: Option[ProviderName] = scala
      .Option(impl.providerName())
      .map(value => zio.aws.directconnect.model.primitives.ProviderName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.Interconnect
  ): zio.aws.directconnect.model.Interconnect.ReadOnly = new Wrapper(impl)
}
