package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.{SecretARN, ConnectionId}
import scala.jdk.CollectionConverters._
final case class DisassociateMacSecKeyRequest(
    connectionId: ConnectionId,
    secretARN: SecretARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyRequest = {
    import DisassociateMacSecKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .secretARN(SecretARN.unwrap(secretARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DisassociateMacSecKeyRequest.ReadOnly =
    zio.aws.directconnect.model.DisassociateMacSecKeyRequest
      .wrap(buildAwsValue())
}
object DisassociateMacSecKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DisassociateMacSecKeyRequest =
      zio.aws.directconnect.model
        .DisassociateMacSecKeyRequest(connectionId, secretARN)
    def connectionId: ConnectionId
    def secretARN: SecretARN
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
    def getSecretARN: ZIO[Any, Nothing, SecretARN] = ZIO.succeed(secretARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyRequest
  ) extends zio.aws.directconnect.model.DisassociateMacSecKeyRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
    override val secretARN: SecretARN =
      zio.aws.directconnect.model.primitives.SecretARN(impl.secretARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyRequest
  ): zio.aws.directconnect.model.DisassociateMacSecKeyRequest.ReadOnly =
    new Wrapper(impl)
}
