package zio.aws.directconnect.model
import scala.jdk.CollectionConverters._
sealed trait DirectConnectGatewayAttachmentType {
  def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType
}
object DirectConnectGatewayAttachmentType {
  def wrap(
      value: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType
  ): zio.aws.directconnect.model.DirectConnectGatewayAttachmentType =
    value match {
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType.TRANSIT_VIRTUAL_INTERFACE =>
        val r = TransitVirtualInterface
        r
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType.PRIVATE_VIRTUAL_INTERFACE =>
        val r = PrivateVirtualInterface
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.directconnect.model.DirectConnectGatewayAttachmentType {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType.UNKNOWN_TO_SDK_VERSION
  }
  case object TransitVirtualInterface
      extends zio.aws.directconnect.model.DirectConnectGatewayAttachmentType {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType.TRANSIT_VIRTUAL_INTERFACE
  }
  case object PrivateVirtualInterface
      extends zio.aws.directconnect.model.DirectConnectGatewayAttachmentType {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType.PRIVATE_VIRTUAL_INTERFACE
  }
}
