package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{VirtualInterfaceId, ConnectionId}
import scala.jdk.CollectionConverters._
final case class DescribeVirtualInterfacesRequest(
    connectionId: Option[ConnectionId] = None,
    virtualInterfaceId: Option[VirtualInterfaceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest = {
    import DescribeVirtualInterfacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest
      .builder()
      .optionallyWith(
        connectionId.map(value => ConnectionId.unwrap(value): java.lang.String)
      )(_.connectionId)
      .optionallyWith(
        virtualInterfaceId.map(value =>
          VirtualInterfaceId.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceId)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeVirtualInterfacesRequest.ReadOnly =
    zio.aws.directconnect.model.DescribeVirtualInterfacesRequest
      .wrap(buildAwsValue())
}
object DescribeVirtualInterfacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeVirtualInterfacesRequest =
      zio.aws.directconnect.model.DescribeVirtualInterfacesRequest(
        connectionId.map(value => value),
        virtualInterfaceId.map(value => value)
      )
    def connectionId: Option[ConnectionId]
    def virtualInterfaceId: Option[VirtualInterfaceId]
    def getConnectionId: ZIO[Any, AwsError, ConnectionId] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getVirtualInterfaceId: ZIO[Any, AwsError, VirtualInterfaceId] =
      AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest
  ) extends zio.aws.directconnect.model.DescribeVirtualInterfacesRequest.ReadOnly {
    override val connectionId: Option[ConnectionId] = scala
      .Option(impl.connectionId())
      .map(value => zio.aws.directconnect.model.primitives.ConnectionId(value))
    override val virtualInterfaceId: Option[VirtualInterfaceId] = scala
      .Option(impl.virtualInterfaceId())
      .map(value =>
        zio.aws.directconnect.model.primitives.VirtualInterfaceId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest
  ): zio.aws.directconnect.model.DescribeVirtualInterfacesRequest.ReadOnly =
    new Wrapper(impl)
}
