package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeLocationsResponse(
    locations: Option[Iterable[zio.aws.directconnect.model.Location]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeLocationsResponse = {
    import DescribeLocationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeLocationsResponse
      .builder()
      .optionallyWith(
        locations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.locations)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeLocationsResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeLocationsResponse.wrap(buildAwsValue())
}
object DescribeLocationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeLocationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DescribeLocationsResponse =
      zio.aws.directconnect.model.DescribeLocationsResponse(
        locations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def locations: Option[List[zio.aws.directconnect.model.Location.ReadOnly]]
    def getLocations: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.Location.ReadOnly
    ]] = AwsError.unwrapOptionField("locations", locations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeLocationsResponse
  ) extends zio.aws.directconnect.model.DescribeLocationsResponse.ReadOnly {
    override val locations
        : Option[List[zio.aws.directconnect.model.Location.ReadOnly]] = scala
      .Option(impl.locations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.Location.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeLocationsResponse
  ): zio.aws.directconnect.model.DescribeLocationsResponse.ReadOnly =
    new Wrapper(impl)
}
