package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.LoaContent
import scala.jdk.CollectionConverters._
final case class DescribeLoaResponse(
    loaContent: Option[LoaContent] = None,
    loaContentType: Option[zio.aws.directconnect.model.LoaContentType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeLoaResponse = {
    import DescribeLoaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeLoaResponse
      .builder()
      .optionallyWith(
        loaContent.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.loaContent)
      .optionallyWith(loaContentType.map(value => value.unwrap))(
        _.loaContentType
      )
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.DescribeLoaResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeLoaResponse.wrap(buildAwsValue())
}
object DescribeLoaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeLoaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DescribeLoaResponse =
      zio.aws.directconnect.model.DescribeLoaResponse(
        loaContent.map(value => value),
        loaContentType.map(value => value)
      )
    def loaContent: Option[LoaContent]
    def loaContentType: Option[zio.aws.directconnect.model.LoaContentType]
    def getLoaContent: ZIO[Any, AwsError, LoaContent] =
      AwsError.unwrapOptionField("loaContent", loaContent)
    def getLoaContentType
        : ZIO[Any, AwsError, zio.aws.directconnect.model.LoaContentType] =
      AwsError.unwrapOptionField("loaContentType", loaContentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeLoaResponse
  ) extends zio.aws.directconnect.model.DescribeLoaResponse.ReadOnly {
    override val loaContent: Option[LoaContent] = scala
      .Option(impl.loaContent())
      .map(value =>
        zio.aws.directconnect.model.primitives
          .LoaContent(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val loaContentType
        : Option[zio.aws.directconnect.model.LoaContentType] = scala
      .Option(impl.loaContentType())
      .map(value => zio.aws.directconnect.model.LoaContentType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeLoaResponse
  ): zio.aws.directconnect.model.DescribeLoaResponse.ReadOnly = new Wrapper(
    impl
  )
}
