package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class DescribeDirectConnectGatewayAssociationsResponse(
    directConnectGatewayAssociations: Option[
      Iterable[zio.aws.directconnect.model.DirectConnectGatewayAssociation]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse = {
    import DescribeDirectConnectGatewayAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse
      .builder()
      .optionallyWith(
        directConnectGatewayAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.directConnectGatewayAssociations)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeDirectConnectGatewayAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse =
      zio.aws.directconnect.model
        .DescribeDirectConnectGatewayAssociationsResponse(
          directConnectGatewayAssociations.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def directConnectGatewayAssociations: Option[
      List[zio.aws.directconnect.model.DirectConnectGatewayAssociation.ReadOnly]
    ]
    def nextToken: Option[PaginationToken]
    def getDirectConnectGatewayAssociations: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.DirectConnectGatewayAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "directConnectGatewayAssociations",
      directConnectGatewayAssociations
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse
  ) extends zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse.ReadOnly {
    override val directConnectGatewayAssociations: Option[
      List[zio.aws.directconnect.model.DirectConnectGatewayAssociation.ReadOnly]
    ] = scala
      .Option(impl.directConnectGatewayAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.DirectConnectGatewayAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.directconnect.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse
  ): zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
