package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeCustomerMetadataResponse(
    agreements: Option[
      Iterable[zio.aws.directconnect.model.CustomerAgreement]
    ] = None,
    nniPartnerType: Option[zio.aws.directconnect.model.NniPartnerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeCustomerMetadataResponse = {
    import DescribeCustomerMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeCustomerMetadataResponse
      .builder()
      .optionallyWith(
        agreements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.agreements)
      .optionallyWith(nniPartnerType.map(value => value.unwrap))(
        _.nniPartnerType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeCustomerMetadataResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeCustomerMetadataResponse
      .wrap(buildAwsValue())
}
object DescribeCustomerMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeCustomerMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeCustomerMetadataResponse =
      zio.aws.directconnect.model.DescribeCustomerMetadataResponse(
        agreements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nniPartnerType.map(value => value)
      )
    def agreements
        : Option[List[zio.aws.directconnect.model.CustomerAgreement.ReadOnly]]
    def nniPartnerType: Option[zio.aws.directconnect.model.NniPartnerType]
    def getAgreements: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.CustomerAgreement.ReadOnly
    ]] = AwsError.unwrapOptionField("agreements", agreements)
    def getNniPartnerType
        : ZIO[Any, AwsError, zio.aws.directconnect.model.NniPartnerType] =
      AwsError.unwrapOptionField("nniPartnerType", nniPartnerType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeCustomerMetadataResponse
  ) extends zio.aws.directconnect.model.DescribeCustomerMetadataResponse.ReadOnly {
    override val agreements
        : Option[List[zio.aws.directconnect.model.CustomerAgreement.ReadOnly]] =
      scala
        .Option(impl.agreements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.CustomerAgreement.wrap(item)
          }.toList
        )
    override val nniPartnerType
        : Option[zio.aws.directconnect.model.NniPartnerType] = scala
      .Option(impl.nniPartnerType())
      .map(value => zio.aws.directconnect.model.NniPartnerType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeCustomerMetadataResponse
  ): zio.aws.directconnect.model.DescribeCustomerMetadataResponse.ReadOnly =
    new Wrapper(impl)
}
