package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteInterconnectResponse(
    interconnectState: Option[zio.aws.directconnect.model.InterconnectState] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DeleteInterconnectResponse = {
    import DeleteInterconnectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DeleteInterconnectResponse
      .builder()
      .optionallyWith(interconnectState.map(value => value.unwrap))(
        _.interconnectState
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DeleteInterconnectResponse.ReadOnly =
    zio.aws.directconnect.model.DeleteInterconnectResponse.wrap(buildAwsValue())
}
object DeleteInterconnectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DeleteInterconnectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DeleteInterconnectResponse =
      zio.aws.directconnect.model
        .DeleteInterconnectResponse(interconnectState.map(value => value))
    def interconnectState: Option[zio.aws.directconnect.model.InterconnectState]
    def getInterconnectState
        : ZIO[Any, AwsError, zio.aws.directconnect.model.InterconnectState] =
      AwsError.unwrapOptionField("interconnectState", interconnectState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteInterconnectResponse
  ) extends zio.aws.directconnect.model.DeleteInterconnectResponse.ReadOnly {
    override val interconnectState
        : Option[zio.aws.directconnect.model.InterconnectState] = scala
      .Option(impl.interconnectState())
      .map(value => zio.aws.directconnect.model.InterconnectState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteInterconnectResponse
  ): zio.aws.directconnect.model.DeleteInterconnectResponse.ReadOnly =
    new Wrapper(impl)
}
