package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.InterconnectId
import scala.jdk.CollectionConverters._
final case class DeleteInterconnectRequest(interconnectId: InterconnectId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest = {
    import DeleteInterconnectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest
      .builder()
      .interconnectId(InterconnectId.unwrap(interconnectId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DeleteInterconnectRequest.ReadOnly =
    zio.aws.directconnect.model.DeleteInterconnectRequest.wrap(buildAwsValue())
}
object DeleteInterconnectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DeleteInterconnectRequest =
      zio.aws.directconnect.model.DeleteInterconnectRequest(interconnectId)
    def interconnectId: InterconnectId
    def getInterconnectId: ZIO[Any, Nothing, InterconnectId] =
      ZIO.succeed(interconnectId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest
  ) extends zio.aws.directconnect.model.DeleteInterconnectRequest.ReadOnly {
    override val interconnectId: InterconnectId =
      zio.aws.directconnect.model.primitives
        .InterconnectId(impl.interconnectId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest
  ): zio.aws.directconnect.model.DeleteInterconnectRequest.ReadOnly =
    new Wrapper(impl)
}
