package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  VirtualGatewayId,
  DirectConnectGatewayId,
  DirectConnectGatewayAssociationId
}
import scala.jdk.CollectionConverters._
final case class DeleteDirectConnectGatewayAssociationRequest(
    associationId: Option[DirectConnectGatewayAssociationId] = None,
    directConnectGatewayId: Option[DirectConnectGatewayId] = None,
    virtualGatewayId: Option[VirtualGatewayId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest = {
    import DeleteDirectConnectGatewayAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest
      .builder()
      .optionallyWith(
        associationId.map(value =>
          DirectConnectGatewayAssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        directConnectGatewayId.map(value =>
          DirectConnectGatewayId.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayId)
      .optionallyWith(
        virtualGatewayId.map(value =>
          VirtualGatewayId.unwrap(value): java.lang.String
        )
      )(_.virtualGatewayId)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationRequest.ReadOnly =
    zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationRequest
      .wrap(buildAwsValue())
}
object DeleteDirectConnectGatewayAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationRequest =
      zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationRequest(
        associationId.map(value => value),
        directConnectGatewayId.map(value => value),
        virtualGatewayId.map(value => value)
      )
    def associationId: Option[DirectConnectGatewayAssociationId]
    def directConnectGatewayId: Option[DirectConnectGatewayId]
    def virtualGatewayId: Option[VirtualGatewayId]
    def getAssociationId
        : ZIO[Any, AwsError, DirectConnectGatewayAssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getDirectConnectGatewayId: ZIO[Any, AwsError, DirectConnectGatewayId] =
      AwsError.unwrapOptionField(
        "directConnectGatewayId",
        directConnectGatewayId
      )
    def getVirtualGatewayId: ZIO[Any, AwsError, VirtualGatewayId] =
      AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest
  ) extends zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationRequest.ReadOnly {
    override val associationId: Option[DirectConnectGatewayAssociationId] =
      scala
        .Option(impl.associationId())
        .map(value =>
          zio.aws.directconnect.model.primitives
            .DirectConnectGatewayAssociationId(value)
        )
    override val directConnectGatewayId: Option[DirectConnectGatewayId] = scala
      .Option(impl.directConnectGatewayId())
      .map(value =>
        zio.aws.directconnect.model.primitives.DirectConnectGatewayId(value)
      )
    override val virtualGatewayId: Option[VirtualGatewayId] = scala
      .Option(impl.virtualGatewayId())
      .map(value =>
        zio.aws.directconnect.model.primitives.VirtualGatewayId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest
  ): zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
