package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateTransitVirtualInterfaceResponse(
    virtualInterface: Option[zio.aws.directconnect.model.VirtualInterface] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceResponse = {
    import CreateTransitVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceResponse
      .builder()
      .optionallyWith(virtualInterface.map(value => value.buildAwsValue()))(
        _.virtualInterface
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.CreateTransitVirtualInterfaceResponse.ReadOnly =
    zio.aws.directconnect.model.CreateTransitVirtualInterfaceResponse
      .wrap(buildAwsValue())
}
object CreateTransitVirtualInterfaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.CreateTransitVirtualInterfaceResponse =
      zio.aws.directconnect.model.CreateTransitVirtualInterfaceResponse(
        virtualInterface.map(value => value.asEditable)
      )
    def virtualInterface
        : Option[zio.aws.directconnect.model.VirtualInterface.ReadOnly]
    def getVirtualInterface: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.VirtualInterface.ReadOnly
    ] = AwsError.unwrapOptionField("virtualInterface", virtualInterface)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceResponse
  ) extends zio.aws.directconnect.model.CreateTransitVirtualInterfaceResponse.ReadOnly {
    override val virtualInterface
        : Option[zio.aws.directconnect.model.VirtualInterface.ReadOnly] = scala
      .Option(impl.virtualInterface())
      .map(value => zio.aws.directconnect.model.VirtualInterface.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceResponse
  ): zio.aws.directconnect.model.CreateTransitVirtualInterfaceResponse.ReadOnly =
    new Wrapper(impl)
}
