package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.Status
import scala.jdk.CollectionConverters._
final case class ConfirmCustomerAgreementResponse(
    status: Option[Status] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementResponse = {
    import ConfirmCustomerAgreementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementResponse
      .builder()
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.ConfirmCustomerAgreementResponse.ReadOnly =
    zio.aws.directconnect.model.ConfirmCustomerAgreementResponse
      .wrap(buildAwsValue())
}
object ConfirmCustomerAgreementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.ConfirmCustomerAgreementResponse =
      zio.aws.directconnect.model
        .ConfirmCustomerAgreementResponse(status.map(value => value))
    def status: Option[Status]
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementResponse
  ) extends zio.aws.directconnect.model.ConfirmCustomerAgreementResponse.ReadOnly {
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.directconnect.model.primitives.Status(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementResponse
  ): zio.aws.directconnect.model.ConfirmCustomerAgreementResponse.ReadOnly =
    new Wrapper(impl)
}
