package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.AgreementName
import scala.jdk.CollectionConverters._
final case class ConfirmCustomerAgreementRequest(
    agreementName: Option[AgreementName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementRequest = {
    import ConfirmCustomerAgreementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementRequest
      .builder()
      .optionallyWith(
        agreementName.map(value =>
          AgreementName.unwrap(value): java.lang.String
        )
      )(_.agreementName)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.ConfirmCustomerAgreementRequest.ReadOnly =
    zio.aws.directconnect.model.ConfirmCustomerAgreementRequest
      .wrap(buildAwsValue())
}
object ConfirmCustomerAgreementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.ConfirmCustomerAgreementRequest =
      zio.aws.directconnect.model
        .ConfirmCustomerAgreementRequest(agreementName.map(value => value))
    def agreementName: Option[AgreementName]
    def getAgreementName: ZIO[Any, AwsError, AgreementName] =
      AwsError.unwrapOptionField("agreementName", agreementName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementRequest
  ) extends zio.aws.directconnect.model.ConfirmCustomerAgreementRequest.ReadOnly {
    override val agreementName: Option[AgreementName] = scala
      .Option(impl.agreementName())
      .map(value => zio.aws.directconnect.model.primitives.AgreementName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementRequest
  ): zio.aws.directconnect.model.ConfirmCustomerAgreementRequest.ReadOnly =
    new Wrapper(impl)
}
