package zio.aws.directconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  AwsDeviceV2,
  BGPAuthKey,
  AwsLogicalDeviceId,
  ASN,
  AmazonAddress,
  CustomerAddress,
  BGPPeerId
}
import scala.jdk.CollectionConverters._
final case class BGPPeer(
    bgpPeerId: Option[BGPPeerId] = None,
    asn: Option[ASN] = None,
    authKey: Option[BGPAuthKey] = None,
    addressFamily: Option[zio.aws.directconnect.model.AddressFamily] = None,
    amazonAddress: Option[AmazonAddress] = None,
    customerAddress: Option[CustomerAddress] = None,
    bgpPeerState: Option[zio.aws.directconnect.model.BGPPeerState] = None,
    bgpStatus: Option[zio.aws.directconnect.model.BGPStatus] = None,
    awsDeviceV2: Option[AwsDeviceV2] = None,
    awsLogicalDeviceId: Option[AwsLogicalDeviceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.BGPPeer = {
    import BGPPeer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.BGPPeer
      .builder()
      .optionallyWith(
        bgpPeerId.map(value => BGPPeerId.unwrap(value): java.lang.String)
      )(_.bgpPeerId)
      .optionallyWith(asn.map(value => ASN.unwrap(value): Integer))(_.asn)
      .optionallyWith(
        authKey.map(value => BGPAuthKey.unwrap(value): java.lang.String)
      )(_.authKey)
      .optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily)
      .optionallyWith(
        amazonAddress.map(value =>
          AmazonAddress.unwrap(value): java.lang.String
        )
      )(_.amazonAddress)
      .optionallyWith(
        customerAddress.map(value =>
          CustomerAddress.unwrap(value): java.lang.String
        )
      )(_.customerAddress)
      .optionallyWith(bgpPeerState.map(value => value.unwrap))(_.bgpPeerState)
      .optionallyWith(bgpStatus.map(value => value.unwrap))(_.bgpStatus)
      .optionallyWith(
        awsDeviceV2.map(value => AwsDeviceV2.unwrap(value): java.lang.String)
      )(_.awsDeviceV2)
      .optionallyWith(
        awsLogicalDeviceId.map(value =>
          AwsLogicalDeviceId.unwrap(value): java.lang.String
        )
      )(_.awsLogicalDeviceId)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.BGPPeer.ReadOnly =
    zio.aws.directconnect.model.BGPPeer.wrap(buildAwsValue())
}
object BGPPeer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.BGPPeer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.BGPPeer =
      zio.aws.directconnect.model.BGPPeer(
        bgpPeerId.map(value => value),
        asn.map(value => value),
        authKey.map(value => value),
        addressFamily.map(value => value),
        amazonAddress.map(value => value),
        customerAddress.map(value => value),
        bgpPeerState.map(value => value),
        bgpStatus.map(value => value),
        awsDeviceV2.map(value => value),
        awsLogicalDeviceId.map(value => value)
      )
    def bgpPeerId: Option[BGPPeerId]
    def asn: Option[ASN]
    def authKey: Option[BGPAuthKey]
    def addressFamily: Option[zio.aws.directconnect.model.AddressFamily]
    def amazonAddress: Option[AmazonAddress]
    def customerAddress: Option[CustomerAddress]
    def bgpPeerState: Option[zio.aws.directconnect.model.BGPPeerState]
    def bgpStatus: Option[zio.aws.directconnect.model.BGPStatus]
    def awsDeviceV2: Option[AwsDeviceV2]
    def awsLogicalDeviceId: Option[AwsLogicalDeviceId]
    def getBgpPeerId: ZIO[Any, AwsError, BGPPeerId] =
      AwsError.unwrapOptionField("bgpPeerId", bgpPeerId)
    def getAsn: ZIO[Any, AwsError, ASN] = AwsError.unwrapOptionField("asn", asn)
    def getAuthKey: ZIO[Any, AwsError, BGPAuthKey] =
      AwsError.unwrapOptionField("authKey", authKey)
    def getAddressFamily
        : ZIO[Any, AwsError, zio.aws.directconnect.model.AddressFamily] =
      AwsError.unwrapOptionField("addressFamily", addressFamily)
    def getAmazonAddress: ZIO[Any, AwsError, AmazonAddress] =
      AwsError.unwrapOptionField("amazonAddress", amazonAddress)
    def getCustomerAddress: ZIO[Any, AwsError, CustomerAddress] =
      AwsError.unwrapOptionField("customerAddress", customerAddress)
    def getBgpPeerState
        : ZIO[Any, AwsError, zio.aws.directconnect.model.BGPPeerState] =
      AwsError.unwrapOptionField("bgpPeerState", bgpPeerState)
    def getBgpStatus
        : ZIO[Any, AwsError, zio.aws.directconnect.model.BGPStatus] =
      AwsError.unwrapOptionField("bgpStatus", bgpStatus)
    def getAwsDeviceV2: ZIO[Any, AwsError, AwsDeviceV2] =
      AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2)
    def getAwsLogicalDeviceId: ZIO[Any, AwsError, AwsLogicalDeviceId] =
      AwsError.unwrapOptionField("awsLogicalDeviceId", awsLogicalDeviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.BGPPeer
  ) extends zio.aws.directconnect.model.BGPPeer.ReadOnly {
    override val bgpPeerId: Option[BGPPeerId] = scala
      .Option(impl.bgpPeerId())
      .map(value => zio.aws.directconnect.model.primitives.BGPPeerId(value))
    override val asn: Option[ASN] = scala
      .Option(impl.asn())
      .map(value => zio.aws.directconnect.model.primitives.ASN(value))
    override val authKey: Option[BGPAuthKey] = scala
      .Option(impl.authKey())
      .map(value => zio.aws.directconnect.model.primitives.BGPAuthKey(value))
    override val addressFamily
        : Option[zio.aws.directconnect.model.AddressFamily] = scala
      .Option(impl.addressFamily())
      .map(value => zio.aws.directconnect.model.AddressFamily.wrap(value))
    override val amazonAddress: Option[AmazonAddress] = scala
      .Option(impl.amazonAddress())
      .map(value => zio.aws.directconnect.model.primitives.AmazonAddress(value))
    override val customerAddress: Option[CustomerAddress] = scala
      .Option(impl.customerAddress())
      .map(value =>
        zio.aws.directconnect.model.primitives.CustomerAddress(value)
      )
    override val bgpPeerState
        : Option[zio.aws.directconnect.model.BGPPeerState] = scala
      .Option(impl.bgpPeerState())
      .map(value => zio.aws.directconnect.model.BGPPeerState.wrap(value))
    override val bgpStatus: Option[zio.aws.directconnect.model.BGPStatus] =
      scala
        .Option(impl.bgpStatus())
        .map(value => zio.aws.directconnect.model.BGPStatus.wrap(value))
    override val awsDeviceV2: Option[AwsDeviceV2] = scala
      .Option(impl.awsDeviceV2())
      .map(value => zio.aws.directconnect.model.primitives.AwsDeviceV2(value))
    override val awsLogicalDeviceId: Option[AwsLogicalDeviceId] = scala
      .Option(impl.awsLogicalDeviceId())
      .map(value =>
        zio.aws.directconnect.model.primitives.AwsLogicalDeviceId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.BGPPeer
  ): zio.aws.directconnect.model.BGPPeer.ReadOnly = new Wrapper(impl)
}
