package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.{ConnectionId, VirtualInterfaceId}
import scala.jdk.CollectionConverters._
final case class AssociateVirtualInterfaceRequest(
    virtualInterfaceId: VirtualInterfaceId,
    connectionId: ConnectionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest = {
    import AssociateVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest
      .builder()
      .virtualInterfaceId(
        VirtualInterfaceId.unwrap(virtualInterfaceId): java.lang.String
      )
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.AssociateVirtualInterfaceRequest.ReadOnly =
    zio.aws.directconnect.model.AssociateVirtualInterfaceRequest
      .wrap(buildAwsValue())
}
object AssociateVirtualInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.AssociateVirtualInterfaceRequest =
      zio.aws.directconnect.model
        .AssociateVirtualInterfaceRequest(virtualInterfaceId, connectionId)
    def virtualInterfaceId: VirtualInterfaceId
    def connectionId: ConnectionId
    def getVirtualInterfaceId: ZIO[Any, Nothing, VirtualInterfaceId] =
      ZIO.succeed(virtualInterfaceId)
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest
  ) extends zio.aws.directconnect.model.AssociateVirtualInterfaceRequest.ReadOnly {
    override val virtualInterfaceId: VirtualInterfaceId =
      zio.aws.directconnect.model.primitives
        .VirtualInterfaceId(impl.virtualInterfaceId())
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest
  ): zio.aws.directconnect.model.AssociateVirtualInterfaceRequest.ReadOnly =
    new Wrapper(impl)
}
