package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  Cak,
  Ckn,
  SecretARN,
  ConnectionId
}
import scala.jdk.CollectionConverters._
final case class AssociateMacSecKeyRequest(
    connectionId: ConnectionId,
    secretARN: Option[SecretARN] = None,
    ckn: Option[Ckn] = None,
    cak: Option[Cak] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyRequest = {
    import AssociateMacSecKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .optionallyWith(
        secretARN.map(value => SecretARN.unwrap(value): java.lang.String)
      )(_.secretARN)
      .optionallyWith(ckn.map(value => Ckn.unwrap(value): java.lang.String))(
        _.ckn
      )
      .optionallyWith(cak.map(value => Cak.unwrap(value): java.lang.String))(
        _.cak
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.AssociateMacSecKeyRequest.ReadOnly =
    zio.aws.directconnect.model.AssociateMacSecKeyRequest.wrap(buildAwsValue())
}
object AssociateMacSecKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.AssociateMacSecKeyRequest =
      zio.aws.directconnect.model.AssociateMacSecKeyRequest(
        connectionId,
        secretARN.map(value => value),
        ckn.map(value => value),
        cak.map(value => value)
      )
    def connectionId: ConnectionId
    def secretARN: Option[SecretARN]
    def ckn: Option[Ckn]
    def cak: Option[Cak]
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
    def getSecretARN: ZIO[Any, AwsError, SecretARN] =
      AwsError.unwrapOptionField("secretARN", secretARN)
    def getCkn: ZIO[Any, AwsError, Ckn] = AwsError.unwrapOptionField("ckn", ckn)
    def getCak: ZIO[Any, AwsError, Cak] = AwsError.unwrapOptionField("cak", cak)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyRequest
  ) extends zio.aws.directconnect.model.AssociateMacSecKeyRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
    override val secretARN: Option[SecretARN] = scala
      .Option(impl.secretARN())
      .map(value => zio.aws.directconnect.model.primitives.SecretARN(value))
    override val ckn: Option[Ckn] = scala
      .Option(impl.ckn())
      .map(value => zio.aws.directconnect.model.primitives.Ckn(value))
    override val cak: Option[Cak] = scala
      .Option(impl.cak())
      .map(value => zio.aws.directconnect.model.primitives.Cak(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyRequest
  ): zio.aws.directconnect.model.AssociateMacSecKeyRequest.ReadOnly =
    new Wrapper(impl)
}
