package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.{OwnerAccount, ConnectionId}
import scala.jdk.CollectionConverters._
final case class AllocatePublicVirtualInterfaceRequest(
    connectionId: ConnectionId,
    ownerAccount: OwnerAccount,
    newPublicVirtualInterfaceAllocation: zio.aws.directconnect.model.NewPublicVirtualInterfaceAllocation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest = {
    import AllocatePublicVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .ownerAccount(OwnerAccount.unwrap(ownerAccount): java.lang.String)
      .newPublicVirtualInterfaceAllocation(
        newPublicVirtualInterfaceAllocation.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.AllocatePublicVirtualInterfaceRequest.ReadOnly =
    zio.aws.directconnect.model.AllocatePublicVirtualInterfaceRequest
      .wrap(buildAwsValue())
}
object AllocatePublicVirtualInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.AllocatePublicVirtualInterfaceRequest =
      zio.aws.directconnect.model.AllocatePublicVirtualInterfaceRequest(
        connectionId,
        ownerAccount,
        newPublicVirtualInterfaceAllocation.asEditable
      )
    def connectionId: ConnectionId
    def ownerAccount: OwnerAccount
    def newPublicVirtualInterfaceAllocation
        : zio.aws.directconnect.model.NewPublicVirtualInterfaceAllocation.ReadOnly
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
    def getOwnerAccount: ZIO[Any, Nothing, OwnerAccount] =
      ZIO.succeed(ownerAccount)
    def getNewPublicVirtualInterfaceAllocation: ZIO[
      Any,
      Nothing,
      zio.aws.directconnect.model.NewPublicVirtualInterfaceAllocation.ReadOnly
    ] = ZIO.succeed(newPublicVirtualInterfaceAllocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest
  ) extends zio.aws.directconnect.model.AllocatePublicVirtualInterfaceRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
    override val ownerAccount: OwnerAccount =
      zio.aws.directconnect.model.primitives.OwnerAccount(impl.ownerAccount())
    override val newPublicVirtualInterfaceAllocation
        : zio.aws.directconnect.model.NewPublicVirtualInterfaceAllocation.ReadOnly =
      zio.aws.directconnect.model.NewPublicVirtualInterfaceAllocation
        .wrap(impl.newPublicVirtualInterfaceAllocation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest
  ): zio.aws.directconnect.model.AllocatePublicVirtualInterfaceRequest.ReadOnly =
    new Wrapper(impl)
}
