package zio.aws.directconnect.model
import zio.aws.directconnect.model.primitives.{
  PortEncryptionStatus,
  VLAN,
  OwnerAccount,
  EncryptionMode,
  ConnectionId,
  ProviderName,
  ConnectionName,
  AwsDeviceV2,
  MacSecCapable,
  Bandwidth,
  Region,
  AwsLogicalDeviceId,
  AwsDevice,
  PartnerName,
  JumboFrameCapable,
  LagId,
  LocationCode,
  LoaIssueTime
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AllocateHostedConnectionResponse(
    ownerAccount: Option[OwnerAccount] = None,
    connectionId: Option[ConnectionId] = None,
    connectionName: Option[ConnectionName] = None,
    connectionState: Option[zio.aws.directconnect.model.ConnectionState] = None,
    region: Option[Region] = None,
    location: Option[LocationCode] = None,
    bandwidth: Option[Bandwidth] = None,
    vlan: Option[VLAN] = None,
    partnerName: Option[PartnerName] = None,
    loaIssueTime: Option[LoaIssueTime] = None,
    lagId: Option[LagId] = None,
    awsDevice: Option[AwsDevice] = None,
    jumboFrameCapable: Option[JumboFrameCapable] = None,
    awsDeviceV2: Option[AwsDeviceV2] = None,
    awsLogicalDeviceId: Option[AwsLogicalDeviceId] = None,
    hasLogicalRedundancy: Option[
      zio.aws.directconnect.model.HasLogicalRedundancy
    ] = None,
    tags: Option[Iterable[zio.aws.directconnect.model.Tag]] = None,
    providerName: Option[ProviderName] = None,
    macSecCapable: Option[MacSecCapable] = None,
    portEncryptionStatus: Option[PortEncryptionStatus] = None,
    encryptionMode: Option[EncryptionMode] = None,
    macSecKeys: Option[Iterable[zio.aws.directconnect.model.MacSecKey]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionResponse = {
    import AllocateHostedConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionResponse
      .builder()
      .optionallyWith(
        ownerAccount.map(value => OwnerAccount.unwrap(value): java.lang.String)
      )(_.ownerAccount)
      .optionallyWith(
        connectionId.map(value => ConnectionId.unwrap(value): java.lang.String)
      )(_.connectionId)
      .optionallyWith(
        connectionName.map(value =>
          ConnectionName.unwrap(value): java.lang.String
        )
      )(_.connectionName)
      .optionallyWith(connectionState.map(value => value.unwrap))(
        _.connectionState
      )
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        location.map(value => LocationCode.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(
        bandwidth.map(value => Bandwidth.unwrap(value): java.lang.String)
      )(_.bandwidth)
      .optionallyWith(vlan.map(value => VLAN.unwrap(value): Integer))(_.vlan)
      .optionallyWith(
        partnerName.map(value => PartnerName.unwrap(value): java.lang.String)
      )(_.partnerName)
      .optionallyWith(
        loaIssueTime.map(value => LoaIssueTime.unwrap(value): Instant)
      )(_.loaIssueTime)
      .optionallyWith(
        lagId.map(value => LagId.unwrap(value): java.lang.String)
      )(_.lagId)
      .optionallyWith(
        awsDevice.map(value => AwsDevice.unwrap(value): java.lang.String)
      )(_.awsDevice)
      .optionallyWith(
        jumboFrameCapable.map(value =>
          JumboFrameCapable.unwrap(value): java.lang.Boolean
        )
      )(_.jumboFrameCapable)
      .optionallyWith(
        awsDeviceV2.map(value => AwsDeviceV2.unwrap(value): java.lang.String)
      )(_.awsDeviceV2)
      .optionallyWith(
        awsLogicalDeviceId.map(value =>
          AwsLogicalDeviceId.unwrap(value): java.lang.String
        )
      )(_.awsLogicalDeviceId)
      .optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(
        _.hasLogicalRedundancy
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        providerName.map(value => ProviderName.unwrap(value): java.lang.String)
      )(_.providerName)
      .optionallyWith(
        macSecCapable.map(value =>
          MacSecCapable.unwrap(value): java.lang.Boolean
        )
      )(_.macSecCapable)
      .optionallyWith(
        portEncryptionStatus.map(value =>
          PortEncryptionStatus.unwrap(value): java.lang.String
        )
      )(_.portEncryptionStatus)
      .optionallyWith(
        encryptionMode.map(value =>
          EncryptionMode.unwrap(value): java.lang.String
        )
      )(_.encryptionMode)
      .optionallyWith(
        macSecKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.macSecKeys)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.AllocateHostedConnectionResponse.ReadOnly =
    zio.aws.directconnect.model.AllocateHostedConnectionResponse
      .wrap(buildAwsValue())
}
object AllocateHostedConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.AllocateHostedConnectionResponse =
      zio.aws.directconnect.model.AllocateHostedConnectionResponse(
        ownerAccount.map(value => value),
        connectionId.map(value => value),
        connectionName.map(value => value),
        connectionState.map(value => value),
        region.map(value => value),
        location.map(value => value),
        bandwidth.map(value => value),
        vlan.map(value => value),
        partnerName.map(value => value),
        loaIssueTime.map(value => value),
        lagId.map(value => value),
        awsDevice.map(value => value),
        jumboFrameCapable.map(value => value),
        awsDeviceV2.map(value => value),
        awsLogicalDeviceId.map(value => value),
        hasLogicalRedundancy.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        providerName.map(value => value),
        macSecCapable.map(value => value),
        portEncryptionStatus.map(value => value),
        encryptionMode.map(value => value),
        macSecKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ownerAccount: Option[OwnerAccount]
    def connectionId: Option[ConnectionId]
    def connectionName: Option[ConnectionName]
    def connectionState: Option[zio.aws.directconnect.model.ConnectionState]
    def region: Option[Region]
    def location: Option[LocationCode]
    def bandwidth: Option[Bandwidth]
    def vlan: Option[VLAN]
    def partnerName: Option[PartnerName]
    def loaIssueTime: Option[LoaIssueTime]
    def lagId: Option[LagId]
    def awsDevice: Option[AwsDevice]
    def jumboFrameCapable: Option[JumboFrameCapable]
    def awsDeviceV2: Option[AwsDeviceV2]
    def awsLogicalDeviceId: Option[AwsLogicalDeviceId]
    def hasLogicalRedundancy
        : Option[zio.aws.directconnect.model.HasLogicalRedundancy]
    def tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def providerName: Option[ProviderName]
    def macSecCapable: Option[MacSecCapable]
    def portEncryptionStatus: Option[PortEncryptionStatus]
    def encryptionMode: Option[EncryptionMode]
    def macSecKeys: Option[List[zio.aws.directconnect.model.MacSecKey.ReadOnly]]
    def getOwnerAccount: ZIO[Any, AwsError, OwnerAccount] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getConnectionId: ZIO[Any, AwsError, ConnectionId] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getConnectionName: ZIO[Any, AwsError, ConnectionName] =
      AwsError.unwrapOptionField("connectionName", connectionName)
    def getConnectionState
        : ZIO[Any, AwsError, zio.aws.directconnect.model.ConnectionState] =
      AwsError.unwrapOptionField("connectionState", connectionState)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getLocation: ZIO[Any, AwsError, LocationCode] =
      AwsError.unwrapOptionField("location", location)
    def getBandwidth: ZIO[Any, AwsError, Bandwidth] =
      AwsError.unwrapOptionField("bandwidth", bandwidth)
    def getVlan: ZIO[Any, AwsError, VLAN] =
      AwsError.unwrapOptionField("vlan", vlan)
    def getPartnerName: ZIO[Any, AwsError, PartnerName] =
      AwsError.unwrapOptionField("partnerName", partnerName)
    def getLoaIssueTime: ZIO[Any, AwsError, LoaIssueTime] =
      AwsError.unwrapOptionField("loaIssueTime", loaIssueTime)
    def getLagId: ZIO[Any, AwsError, LagId] =
      AwsError.unwrapOptionField("lagId", lagId)
    def getAwsDevice: ZIO[Any, AwsError, AwsDevice] =
      AwsError.unwrapOptionField("awsDevice", awsDevice)
    def getJumboFrameCapable: ZIO[Any, AwsError, JumboFrameCapable] =
      AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapable)
    def getAwsDeviceV2: ZIO[Any, AwsError, AwsDeviceV2] =
      AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2)
    def getAwsLogicalDeviceId: ZIO[Any, AwsError, AwsLogicalDeviceId] =
      AwsError.unwrapOptionField("awsLogicalDeviceId", awsLogicalDeviceId)
    def getHasLogicalRedundancy
        : ZIO[Any, AwsError, zio.aws.directconnect.model.HasLogicalRedundancy] =
      AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancy)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getProviderName: ZIO[Any, AwsError, ProviderName] =
      AwsError.unwrapOptionField("providerName", providerName)
    def getMacSecCapable: ZIO[Any, AwsError, MacSecCapable] =
      AwsError.unwrapOptionField("macSecCapable", macSecCapable)
    def getPortEncryptionStatus: ZIO[Any, AwsError, PortEncryptionStatus] =
      AwsError.unwrapOptionField("portEncryptionStatus", portEncryptionStatus)
    def getEncryptionMode: ZIO[Any, AwsError, EncryptionMode] =
      AwsError.unwrapOptionField("encryptionMode", encryptionMode)
    def getMacSecKeys: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.MacSecKey.ReadOnly
    ]] = AwsError.unwrapOptionField("macSecKeys", macSecKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionResponse
  ) extends zio.aws.directconnect.model.AllocateHostedConnectionResponse.ReadOnly {
    override val ownerAccount: Option[OwnerAccount] = scala
      .Option(impl.ownerAccount())
      .map(value => zio.aws.directconnect.model.primitives.OwnerAccount(value))
    override val connectionId: Option[ConnectionId] = scala
      .Option(impl.connectionId())
      .map(value => zio.aws.directconnect.model.primitives.ConnectionId(value))
    override val connectionName: Option[ConnectionName] = scala
      .Option(impl.connectionName())
      .map(value =>
        zio.aws.directconnect.model.primitives.ConnectionName(value)
      )
    override val connectionState
        : Option[zio.aws.directconnect.model.ConnectionState] = scala
      .Option(impl.connectionState())
      .map(value => zio.aws.directconnect.model.ConnectionState.wrap(value))
    override val region: Option[Region] = scala
      .Option(impl.region())
      .map(value => zio.aws.directconnect.model.primitives.Region(value))
    override val location: Option[LocationCode] = scala
      .Option(impl.location())
      .map(value => zio.aws.directconnect.model.primitives.LocationCode(value))
    override val bandwidth: Option[Bandwidth] = scala
      .Option(impl.bandwidth())
      .map(value => zio.aws.directconnect.model.primitives.Bandwidth(value))
    override val vlan: Option[VLAN] = scala
      .Option(impl.vlan())
      .map(value => zio.aws.directconnect.model.primitives.VLAN(value))
    override val partnerName: Option[PartnerName] = scala
      .Option(impl.partnerName())
      .map(value => zio.aws.directconnect.model.primitives.PartnerName(value))
    override val loaIssueTime: Option[LoaIssueTime] = scala
      .Option(impl.loaIssueTime())
      .map(value => zio.aws.directconnect.model.primitives.LoaIssueTime(value))
    override val lagId: Option[LagId] = scala
      .Option(impl.lagId())
      .map(value => zio.aws.directconnect.model.primitives.LagId(value))
    override val awsDevice: Option[AwsDevice] = scala
      .Option(impl.awsDevice())
      .map(value => zio.aws.directconnect.model.primitives.AwsDevice(value))
    override val jumboFrameCapable: Option[JumboFrameCapable] = scala
      .Option(impl.jumboFrameCapable())
      .map(value =>
        zio.aws.directconnect.model.primitives.JumboFrameCapable(value)
      )
    override val awsDeviceV2: Option[AwsDeviceV2] = scala
      .Option(impl.awsDeviceV2())
      .map(value => zio.aws.directconnect.model.primitives.AwsDeviceV2(value))
    override val awsLogicalDeviceId: Option[AwsLogicalDeviceId] = scala
      .Option(impl.awsLogicalDeviceId())
      .map(value =>
        zio.aws.directconnect.model.primitives.AwsLogicalDeviceId(value)
      )
    override val hasLogicalRedundancy
        : Option[zio.aws.directconnect.model.HasLogicalRedundancy] = scala
      .Option(impl.hasLogicalRedundancy())
      .map(value =>
        zio.aws.directconnect.model.HasLogicalRedundancy.wrap(value)
      )
    override val tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
    override val providerName: Option[ProviderName] = scala
      .Option(impl.providerName())
      .map(value => zio.aws.directconnect.model.primitives.ProviderName(value))
    override val macSecCapable: Option[MacSecCapable] = scala
      .Option(impl.macSecCapable())
      .map(value => zio.aws.directconnect.model.primitives.MacSecCapable(value))
    override val portEncryptionStatus: Option[PortEncryptionStatus] = scala
      .Option(impl.portEncryptionStatus())
      .map(value =>
        zio.aws.directconnect.model.primitives.PortEncryptionStatus(value)
      )
    override val encryptionMode: Option[EncryptionMode] = scala
      .Option(impl.encryptionMode())
      .map(value =>
        zio.aws.directconnect.model.primitives.EncryptionMode(value)
      )
    override val macSecKeys
        : Option[List[zio.aws.directconnect.model.MacSecKey.ReadOnly]] = scala
      .Option(impl.macSecKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.MacSecKey.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionResponse
  ): zio.aws.directconnect.model.AllocateHostedConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
